/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.parser;

import com.bokesoft.yes.parser.Item;
import com.bokesoft.yes.parser.Rule;
import java.util.ArrayList;
import java.util.Stack;

public class SyntaxTree {
    private Stack<Item> factorStack = new Stack();
    private Item root = null;

    public void setRoot(Item item) {
        this.root = item;
    }

    public Item getRoot() {
        return this.root;
    }

    protected boolean isEmpty() {
        return this.factorStack.isEmpty();
    }

    public void push(Item item) {
        this.factorStack.push(item);
    }

    public Item peek() {
        return this.factorStack.peek();
    }

    public Item pop() {
        return this.factorStack.pop();
    }

    public void extract() {
        if (!this.factorStack.isEmpty()) {
            this.root = this.factorStack.pop();
        }
    }

    public void optimize() {
        SyntaxTree syntaxTree = this;
        syntaxTree.optimizeFactor(syntaxTree.root);
    }

    private void optimizeFactor(Item item) {
        Rule rule = item.getRule();
        if (rule == null) {
            return;
        }
        ArrayList<Item> arrayList2 = item.getAllChild();
        if (arrayList2 != null) {
            for (Item item2 : arrayList2) {
                this.optimizeFactor(item2);
            }
        }
        switch (rule.getIndex()) {
            case 1: {
                this.optimizeRule1(item);
                return;
            }
            case 19: {
                this.optimizeRule19(item);
                return;
            }
            case 22: {
                this.optimizeRule22(item);
                return;
            }
            case 24: {
                this.optimizeRule23(item);
                return;
            }
            case 26: {
                this.optimizeRule26(item);
                return;
            }
            case 27: {
                this.optimizeRule27(item);
                return;
            }
            case 36: {
                this.optimizeRule36(item);
                return;
            }
            case 38: {
                this.optimizeRule38(item);
            }
        }
    }

    private void optimizeRule1(Item item) {
        Item item2 = item.getFactor(2);
        item.replaceChild(2, item2.getAllChild());
    }

    private void optimizeRule19(Item item) {
        Item item2 = item.getFactor(1);
        item.replaceChild(1, item2.getAllChild());
        item2 = item.getFactor(0);
        item.replaceChild(0, item2.getAllChild());
    }

    private void optimizeRule22(Item item) {
        Item item2 = item.getFactor(0);
        item.replaceChild(0, item2.getAllChild());
    }

    private void optimizeRule23(Item item) {
        Item item2 = item.getFactor(2);
        item.replaceChild(2, item2.getAllChild());
    }

    private void optimizeRule26(Item item) {
        Item item2 = item.getFactor(0);
        item.replaceChild(0, item2.getAllChild());
    }

    private void optimizeRule27(Item item) {
        Item item2 = item.getFactor(1);
        item.replaceChild(1, item2.getAllChild());
        item2 = item.getFactor(0);
        item.replaceChild(0, item2.getAllChild());
    }

    private void optimizeRule36(Item item) {
        Item item2 = item.getFactor(5);
        item.replaceChild(5, item2.getAllChild());
    }

    private void optimizeRule38(Item item) {
        Item item2 = item.getFactor(2);
        item.replaceChild(2, item2.getAllChild());
    }
}

