/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.deparseformula;

import com.bokesoft.yes.parser.Item;
import com.bokesoft.yes.parser.Rule;
import com.bokesoft.yes.parser.SyntaxTree;
import org.apache.commons.lang3.NotImplementedException;

public class FormulaDeparser {
    public static final int RuleIndex_0_Statement = 0;
    public static final int RuleIndex_1_Statements = 1;
    public static final int RuleIndex_2_Addition = 2;
    public static final int RuleIndex_3_Subtraction = 3;
    public static final int RuleIndex_4_Multiplication = 4;
    public static final int RuleIndex_5_Division = 5;
    public static final int RuleIndex_6_Concat = 6;
    public static final int RuleIndex_7_Parenthesis = 7;
    public static final int RuleIndex_8_Not = 8;
    public static final int RuleIndex_9_Or = 9;
    public static final int RuleIndex_10_And = 10;
    public static final int RuleIndex_11_EqualsTo = 11;
    public static final int RuleIndex_12_NotEqualsTo = 12;
    public static final int RuleIndex_13_GreaterThan = 13;
    public static final int RuleIndex_14_GreaterThanEquals = 14;
    public static final int RuleIndex_15_MinorThan = 15;
    public static final int RuleIndex_16_MinorThanEquals = 16;
    public static final int RuleIndex_17_Const = 17;
    public static final int RuleIndex_18_ID = 18;
    public static final int RuleIndex_19_Function = 19;
    public static final int RuleIndex_20_ = 20;
    public static final int RuleIndex_21_ = 21;
    public static final int RuleIndex_22_ = 22;
    public static final int RuleIndex_23_ = 23;
    public static final int RuleIndex_24_ = 24;
    public static final int RuleIndex_25_Var = 25;
    public static final int RuleIndex_26_IfHead = 26;
    public static final int RuleIndex_27_IfElse = 27;
    public static final int RuleIndex_28_IfHead = 28;
    public static final int RuleIndex_29_ = 29;
    public static final int RuleIndex_30_While = 30;
    public static final int RuleIndex_31_SetValue = 31;
    public static final int RuleIndex_32_Return = 32;
    public static final int RuleIndex_33_ = 33;
    public static final int RuleIndex_34_ = 34;
    public static final int RuleIndex_35_ = 35;
    public static final int RuleIndex_36_ = 36;
    public static final int RuleIndex_37_ = 37;
    public static final int RuleIndex_38_ = 38;
    public static final int RuleIndex_39_ = 39;
    public static final FormulaDeparser instance = new FormulaDeparser();

    public static String deParse(SyntaxTree syntaxTree) {
        StringBuilder stringBuilder = new StringBuilder(128);
        return instance.deParse(syntaxTree.getRoot(), stringBuilder).toString();
    }

    public static String deParse(Item item) {
        StringBuilder stringBuilder = new StringBuilder(128);
        return instance.deParse(item, stringBuilder).toString();
    }

    private StringBuilder deParse(Item item, StringBuilder stringBuilder) {
        Rule rule = item.getRule();
        if (rule != null) {
            switch (rule.getIndex()) {
                case 0: {
                    return this.deParse0Statement(item, stringBuilder);
                }
                case 1: {
                    return this.deParse1Statements(item, stringBuilder);
                }
                case 2: {
                    return this.deParse2Addition(item, stringBuilder);
                }
                case 3: {
                    return this.deparse3Subtraction(item, stringBuilder);
                }
                case 4: {
                    return this.deParse4Multiplication(item, stringBuilder);
                }
                case 5: {
                    return this.deParse5Division(item, stringBuilder);
                }
                case 6: {
                    return this.deParse6Concat(item, stringBuilder);
                }
                case 7: {
                    return this.deParse7Parenthesis(item, stringBuilder);
                }
                case 8: {
                    return this.deParse8Not(item, stringBuilder);
                }
                case 9: {
                    return this.deParse9Or(item, stringBuilder);
                }
                case 10: {
                    return this.deParse10And(item, stringBuilder);
                }
                case 11: {
                    return this.deParse11EqualsTo(item, stringBuilder);
                }
                case 12: {
                    return this.deParse12NotEqualsTo(item, stringBuilder);
                }
                case 13: {
                    return this.deParse13GreaterThan(item, stringBuilder);
                }
                case 14: {
                    return this.deParse14GreaterThanEquals(item, stringBuilder);
                }
                case 15: {
                    return this.deParse15MinorThan(item, stringBuilder);
                }
                case 16: {
                    return this.deParse16MinorThanEquals(item, stringBuilder);
                }
                case 17: {
                    return this.deParse17Const(item, stringBuilder);
                }
                case 18: {
                    return this.deParse18ID(item, stringBuilder);
                }
                case 19: {
                    return this.deParse19Function(item, stringBuilder);
                }
                case 20: {
                    throw new NotImplementedException("Code is not implemented");
                }
                case 21: {
                    throw new NotImplementedException("Code is not implemented");
                }
                case 22: {
                    throw new NotImplementedException("Code is not implemented");
                }
                case 23: {
                    throw new NotImplementedException("Code is not implemented");
                }
                case 24: {
                    throw new NotImplementedException("Code is not implemented");
                }
                case 25: {
                    return this.deParse25Var(item, stringBuilder);
                }
                case 26: {
                    return this.deParse26IfHead(item, stringBuilder);
                }
                case 27: {
                    return this.deParse27IfElse(item, stringBuilder);
                }
                case 28: {
                    return this.deParse26IfHead(item, stringBuilder);
                }
                case 29: {
                    throw new NotImplementedException("Code is not implemented");
                }
                case 30: {
                    return this.deParse30While(item, stringBuilder);
                }
                case 31: {
                    return this.deParse31SetValue(item, stringBuilder);
                }
                case 32: {
                    return this.deParse32Return(item, stringBuilder);
                }
                case 33: {
                    throw new NotImplementedException("Code is not implemented");
                }
                case 34: {
                    throw new NotImplementedException("Code is not implemented");
                }
                case 35: {
                    throw new NotImplementedException("Code is not implemented");
                }
                case 36: {
                    throw new NotImplementedException("Code is not implemented");
                }
                case 37: {
                    throw new NotImplementedException("Code is not implemented");
                }
                case 38: {
                    throw new NotImplementedException("Code is not implemented");
                }
                case 39: {
                    throw new NotImplementedException("Code is not implemented");
                }
            }
        }
        throw new NotImplementedException("Code is not implemented");
    }

    private StringBuilder deParse0Statement(Item item, StringBuilder stringBuilder) {
        return this.deParse(item.getFactor(0), stringBuilder);
    }

    private StringBuilder deParse1Statements(Item item, StringBuilder stringBuilder) {
        this.deParse(item.getFactor(0), stringBuilder);
        int n2 = item.getChildCount();
        for (int i2 = 2; i2 < n2; i2 += 2) {
            stringBuilder.append("; ");
            this.deParse(item.getFactor(i2), stringBuilder);
        }
        return stringBuilder;
    }

    private StringBuilder deParse2Addition(Item item, StringBuilder stringBuilder) {
        this.deParse(item.getFactor(0), stringBuilder).append(" + ");
        return this.deParse(item.getFactor(2), stringBuilder);
    }

    private StringBuilder deparse3Subtraction(Item item, StringBuilder stringBuilder) {
        this.deParse(item.getFactor(0), stringBuilder).append(" - ");
        return this.deParse(item.getFactor(2), stringBuilder);
    }

    private StringBuilder deParse4Multiplication(Item item, StringBuilder stringBuilder) {
        this.deParse(item.getFactor(0), stringBuilder).append(" * ");
        return this.deParse(item.getFactor(2), stringBuilder);
    }

    private StringBuilder deParse5Division(Item item, StringBuilder stringBuilder) {
        this.deParse(item.getFactor(0), stringBuilder).append(" / ");
        return this.deParse(item.getFactor(2), stringBuilder);
    }

    private StringBuilder deParse6Concat(Item item, StringBuilder stringBuilder) {
        this.deParse(item.getFactor(0), stringBuilder).append(" & ");
        return this.deParse(item.getFactor(2), stringBuilder);
    }

    private StringBuilder deParse7Parenthesis(Item item, StringBuilder stringBuilder) {
        stringBuilder.append("(");
        this.deParse(item.getFactor(1), stringBuilder);
        return stringBuilder.append(")");
    }

    private StringBuilder deParse8Not(Item item, StringBuilder stringBuilder) {
        stringBuilder.append("!");
        return this.deParse(item.getFactor(1), stringBuilder);
    }

    private StringBuilder deParse9Or(Item item, StringBuilder stringBuilder) {
        this.deParse(item.getFactor(0), stringBuilder).append(" || ");
        return this.deParse(item.getFactor(2), stringBuilder);
    }

    private StringBuilder deParse10And(Item item, StringBuilder stringBuilder) {
        this.deParse(item.getFactor(0), stringBuilder).append(" && ");
        return this.deParse(item.getFactor(2), stringBuilder);
    }

    private StringBuilder deParse11EqualsTo(Item item, StringBuilder stringBuilder) {
        this.deParse(item.getFactor(0), stringBuilder).append(" == ");
        return this.deParse(item.getFactor(2), stringBuilder);
    }

    private StringBuilder deParse12NotEqualsTo(Item item, StringBuilder stringBuilder) {
        this.deParse(item.getFactor(0), stringBuilder).append(" <> ");
        return this.deParse(item.getFactor(2), stringBuilder);
    }

    private StringBuilder deParse13GreaterThan(Item item, StringBuilder stringBuilder) {
        this.deParse(item.getFactor(0), stringBuilder).append(" > ");
        return this.deParse(item.getFactor(2), stringBuilder);
    }

    private StringBuilder deParse14GreaterThanEquals(Item item, StringBuilder stringBuilder) {
        this.deParse(item.getFactor(0), stringBuilder).append(" >= ");
        return this.deParse(item.getFactor(2), stringBuilder);
    }

    private StringBuilder deParse15MinorThan(Item item, StringBuilder stringBuilder) {
        this.deParse(item.getFactor(0), stringBuilder).append(" < ");
        return this.deParse(item.getFactor(2), stringBuilder);
    }

    private StringBuilder deParse16MinorThanEquals(Item item, StringBuilder stringBuilder) {
        this.deParse(item.getFactor(0), stringBuilder).append(" <= ");
        return this.deParse(item.getFactor(2), stringBuilder);
    }

    private StringBuilder deParse17Const(Item object, StringBuilder stringBuilder) {
        if ((object = ((Item)object).getFactor(0).getValue()) instanceof String) {
            return stringBuilder.append("'").append(object).append("'");
        }
        return stringBuilder.append(object);
    }

    private StringBuilder deParse18ID(Item item, StringBuilder stringBuilder) {
        return stringBuilder.append(item.getFactor(0).getFullLexValue());
    }

    private StringBuilder deParse19Function(Item item, StringBuilder stringBuilder) {
        stringBuilder.append(item.getFactor(0).getFullLexValue()).append("(");
        int n2 = item.getChildCount();
        if (n2 >= 4) {
            this.deParse(item.getFactor(2), stringBuilder);
        }
        for (int i2 = 4; i2 < n2; i2 += 2) {
            stringBuilder.append(", ");
            this.deParse(item.getFactor(i2), stringBuilder);
        }
        return stringBuilder.append(")");
    }

    private StringBuilder deParse25Var(Item item, StringBuilder stringBuilder) {
        stringBuilder.append(item.getFactor(0).getFullLexValue()).append(" ");
        stringBuilder.append(item.getFactor(1).getFullLexValue()).append(" = ");
        return this.deParse(item.getFactor(3), stringBuilder);
    }

    private StringBuilder deParse26IfHead(Item item, StringBuilder stringBuilder) {
        stringBuilder.append(item.getFactor(0).getFullLexValue()).append("(");
        this.deParse(item.getFactor(2), stringBuilder).append(") {");
        return this.deParse(item.getFactor(5), stringBuilder).append("}");
    }

    private StringBuilder deParse27IfElse(Item item, StringBuilder stringBuilder) {
        stringBuilder.append(item.getFactor(0).getFullLexValue()).append("(");
        this.deParse(item.getFactor(2), stringBuilder).append(") {");
        this.deParse(item.getFactor(5), stringBuilder).append("} ");
        stringBuilder.append(item.getFactor(7).getFullLexValue()).append(" {");
        return this.deParse(item.getFactor(9), stringBuilder).append("}");
    }

    private StringBuilder deParse30While(Item item, StringBuilder stringBuilder) {
        stringBuilder.append(item.getFactor(0).getFullLexValue()).append(" (");
        this.deParse(item.getFactor(2), stringBuilder).append(") {");
        return this.deParse(item.getFactor(5), stringBuilder).append("}");
    }

    private StringBuilder deParse31SetValue(Item item, StringBuilder stringBuilder) {
        stringBuilder.append(item.getFactor(0).getFullLexValue()).append(" = ");
        return this.deParse(item.getFactor(2), stringBuilder);
    }

    private StringBuilder deParse32Return(Item item, StringBuilder stringBuilder) {
        stringBuilder.append(item.getFactor(0).getFullLexValue()).append(" ");
        return this.deParse(item.getFactor(1), stringBuilder);
    }
}

