package com.bokesoft.yigo.parser;

import com.bokesoft.yes.parser.DefaultFunImplMap;
import com.bokesoft.yes.parser.EvalScope;
import com.bokesoft.yes.parser.IEvalEnv;
import com.bokesoft.yes.parser.IFunImpl;
import com.bokesoft.yes.parser.IHackEvalContext;
import com.bokesoft.yes.parser.IObjectLoop;
import com.bokesoft.yes.parser.Parser;
import com.bokesoft.yes.parser.SyntaxTree;

/**
 * GeneralParser为通用表达式解析类
 * @author wangyh
 *
 * @param <T> 模板参数，为继承类的需要的上下文
 */
public abstract class GeneralParser<T extends IEvalContext> implements IEvalEnv<T>, IEval<T> {
	private Parser<T> parser = null;

	/**
	 * 使用默认的函数实现集初始化一个解析器
	 */
	public GeneralParser() {
		parser = new Parser<T>(DefaultFunImplMap.getInstance());
	}
	
	@Override
	public Object eval(int type, String script, T evalContext, 
			IHackEvalContext<T> hack) throws Throwable {
		return this.eval(type, script, evalContext, hack, null);
	}

	@Override
	public Object eval(int type, String script, T evalContext, 
			IHackEvalContext<T> hack, EvalScope scope) throws Throwable {
		return parser.eval(this, script, evalContext, null);
	}

	@Override
	public Object eval(int type, String script) throws Throwable {
		return eval(type, script, null, null);
	}

	public SyntaxTree parse(String script) throws Throwable {
		SyntaxTree tree = parser.parse(script);
		return tree;
	}
	
	/**
	 * 取数实现
	 * @param evalContext 上下文
	 * @param scope 作用域
	 * @param object 对象名
	 * @param id 标识符
	 * @return 返回值
	 * @throws Throwable 实现相关异常
	 */
	public abstract Object impl_getValue(T evalContext, EvalScope scope, String object, String id) throws Throwable;

	@Override
	public Object getValue(T evalContext, EvalScope scope, String object, String id) throws Throwable {
		return this.impl_getValue(evalContext, scope, object, id);
	}

	@Override
	public void setValue(T evalContext, EvalScope scope, String object, String id, Object value) throws Throwable {
		// TODO Auto-generated method stub

	}

	@Override
	public Object checkMacro(T evalContext, String object, String name) throws Throwable {
		return null;
	}

	@Override
	public Object evalMacro(T evalContext, EvalScope scope, String name, Object macro, Object[] arguments, IExecutor executor) throws Throwable {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public IObjectLoop getLoop(T evalContext, String name, int loop, Object object) throws Throwable {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public SyntaxTree parser(String script) throws Throwable {
		SyntaxTree ret = parser.parse(script);
		return ret;
	}

	@Override
	public Object eval(SyntaxTree script, T evalContext, IHackEvalContext<T> hack) throws Throwable {
		return parser.eval(this, script, evalContext, null);
	}

	@Override
	public Object eval(SyntaxTree script) throws Throwable {
		return parser.eval(this, script, null, null);
	}
	
	@Override
	public Object eval(SyntaxTree script, EvalScope scope) throws Throwable {
		return parser.eval(this, script, null, scope);
	}

	@Override
	public IFunImpl evalFuncImpl(T evalContext, EvalScope scope,
			String object, String name) throws Throwable {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public IEvalContext resolveObject(T self, EvalScope scope,
			String object) throws Throwable {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Object evalObject(T context, String object, String name,
			Object[] arguments) throws Throwable {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void finish() {
		// TODO Auto-generated method stub
		
	}

}
