/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.excel.utils;

import com.bokesoft.yes.excel.template.util.ExcelUtil;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.mid.base.DefaultContext;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class ImportDictionaryHander {
    private String itemKey = null;
    private HashMap<String, ArrayList<String>> importFields = null;
    private Workbook workbook = null;
    private MetaDataObject metaDataObject = null;
    public static String SEPARATOR = ";";

    public ImportDictionaryHander(DefaultContext defaultContext, Workbook workbook) throws Throwable {
        this.workbook = workbook;
        this.init(defaultContext);
    }

    private void init(DefaultContext object) throws Throwable {
        Sheet sheet = this.workbook.getSheetAt(0);
        this.itemKey = ExcelUtil.getCellValue((Sheet)sheet, (int)0, (int)0).toString();
        this.metaDataObject = object.getVE().getMetaFactory().getDataObject(this.itemKey);
        this.importFields = new HashMap();
        int n = this.workbook.getNumberOfSheets();
        for (int i = 0; i < n; ++i) {
            String string;
            sheet = this.workbook.getSheetAt(i);
            object = sheet.getSheetName();
            ArrayList<String> arrayList = new ArrayList<String>();
            this.importFields.put((String)object, arrayList);
            int n2 = 1;
            while (!(string = ExcelUtil.getCellValue((Sheet)sheet, (int)0, (int)n2).toString()).isEmpty()) {
                arrayList.add(string);
                ++n2;
            }
        }
    }

    public String getItemKey() {
        return this.itemKey;
    }

    public HashMap<String, ArrayList<String>> getImportFields() {
        return this.importFields;
    }

    public ArrayList<String> getFieldsByTable(String string) {
        return this.importFields.get(string);
    }

    public String getInsertSQLByTable(String iterator) {
        MetaTable metaTable = this.metaDataObject.getTable((String)((Object)iterator));
        if ((iterator = this.importFields.get(iterator)) == null || ((ArrayList)((Object)iterator)).size() == 0) {
            return "";
        }
        String string = "insert into " + metaTable.getBindingDBTableName();
        String string2 = "OID,POID,SOID,VERID,DVERID";
        String string3 = "?,?,?,?,?";
        iterator = ((ArrayList)((Object)iterator)).iterator();
        while (iterator.hasNext()) {
            String string4 = ((String)iterator.next()).split(SEPARATOR)[0];
            string4 = this.getDBColumnNameByKey(metaTable, string4);
            string2 = string2 + "," + string4;
            string3 = string3 + ",?";
        }
        return string + " (" + string2 + ") values (" + string3 + ")";
    }

    public String getUpdateSQLByTable(String object) {
        MetaTable metaTable = this.metaDataObject.getTable((String)object);
        if ((object = this.importFields.get(object)) == null || ((ArrayList)object).size() == 0) {
            return "";
        }
        String string = "update " + metaTable.getBindingDBTableName() + " set ";
        String string2 = "";
        object = ((ArrayList)object).iterator();
        while (object.hasNext()) {
            String string3 = ((String)object.next()).split(SEPARATOR)[0];
            string3 = this.getDBColumnNameByKey(metaTable, string3);
            string2 = string2 + "," + string3 + "=?";
        }
        object = this.getDBColumnNameByKey(metaTable, "SOID");
        return string + string2.substring(1) + " where " + (String)object + "=?";
    }

    public String getDeleteSQLByTable(String string) {
        string = this.metaDataObject.getTable(string);
        String string2 = this.getDBColumnNameByKey((MetaTable)string, "SOID");
        return "delete from " + string.getBindingDBTableName() + " where " + string2 + "=?";
    }

    private String getDBColumnNameByKey(MetaTable metaTable, String string) {
        return ((MetaColumn)metaTable.get(string)).getBindingDBColumnName();
    }
}

