/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.excel.cmd.stamp.output.strategy;

import com.bokesoft.yes.excel.cmd.stamp.output.process.OutputRowProcess;
import com.bokesoft.yes.excel.cmd.stamp.output.process.OutputSheetProcess;
import com.bokesoft.yes.excel.cmd.stamp.output.strategy.BaseOutputStrategy;
import com.bokesoft.yes.excel.template.ExcelTemplate;
import com.bokesoft.yes.excel.template.ExcelTemplateField;
import com.bokesoft.yes.excel.template.style.StampExcelStyleFactory;
import com.bokesoft.yes.excel.template.util.ExcelUtil;
import java.util.HashMap;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class MultiBatchOutputStrategy
extends BaseOutputStrategy {
    private int tempRowIndex = 0;
    private HashMap<String, Integer> mapDetailStartRowIndex = new HashMap();

    public MultiBatchOutputStrategy(Workbook workbook, StampExcelStyleFactory stampExcelStyleFactory, ExcelTemplate excelTemplate) {
        super(workbook, stampExcelStyleFactory, excelTemplate);
    }

    @Override
    public void insertRow(int n, OutputRowProcess outputRowProcess) {
        int n2 = this.getDetailStartRowIndex();
        ExcelUtil.insertRow((Sheet)this.curSheet, (int)(n2 + n));
    }

    @Override
    public void outputCell(Object object, int n, int n2, ExcelTemplateField excelTemplateField, boolean bl) {
        int n3 = this.getDetailStartRowIndex();
        this.setCellValue(object, n3 + n, n2, excelTemplateField);
        this.tempRowIndex = Math.max(this.tempRowIndex, n);
    }

    @Override
    public void postOutputSheet(OutputSheetProcess object) {
        object = this.curSheet.getSheetName();
        int n = this.getDetailStartRowIndex() + (this.tempRowIndex + 1);
        this.mapDetailStartRowIndex.put((String)object, n);
        this.tempRowIndex = 0;
    }

    @Override
    public void postOutputExcel(ExcelTemplate excelTemplate) {
    }

    protected void preMergedRegion(ExcelTemplateField excelTemplateField, int n, int n2) {
    }

    private int getDetailStartRowIndex() {
        if (!this.mapDetailStartRowIndex.containsKey(this.curSheet.getSheetName())) {
            this.mapDetailStartRowIndex.put(this.curSheet.getSheetName(), 3);
        }
        return this.mapDetailStartRowIndex.get(this.curSheet.getSheetName());
    }
}

