/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.excel.cmd.stamp.input.strategy;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.excel.cmd.stamp.base.ExcelProcessContext;
import com.bokesoft.yes.excel.cmd.stamp.input.doc.in.IInDocument;
import com.bokesoft.yes.excel.cmd.stamp.input.doc.in.IInTable;
import com.bokesoft.yes.excel.cmd.stamp.input.doc.in.InDocument;
import com.bokesoft.yes.excel.cmd.stamp.input.doc.in.InTable4MultiBatch;
import com.bokesoft.yes.excel.cmd.stamp.input.reader.IInputReader;
import com.bokesoft.yes.excel.cmd.stamp.input.reader.IInputReaderBag;
import com.bokesoft.yes.excel.cmd.stamp.input.strategy.IInputStrategy;
import com.bokesoft.yes.excel.cmd.stamp.input.strategy.InDocumentListIterator;
import com.bokesoft.yes.excel.template.ExcelTemplate;
import com.bokesoft.yes.excel.template.ExcelTemplateField;
import com.bokesoft.yes.excel.template.ExcelTemplateTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;

public class MultiBatchInputStrategy
implements IInputStrategy {
    private ExcelTemplate excelTemplate = null;
    private IInputReaderBag workbookReader = null;
    private ExcelProcessContext excelProcessContext = null;
    private LinkedHashMap<Object, IInDocument<IInTable>> mapInDoc = null;
    private Collection<IInDocument<IInTable>> docCollection = null;

    public MultiBatchInputStrategy(ExcelTemplate excelTemplate, IInputReaderBag iInputReaderBag, ExcelProcessContext excelProcessContext) {
        this.excelTemplate = excelTemplate;
        this.workbookReader = iInputReaderBag;
        this.excelProcessContext = excelProcessContext;
        this.mapInDoc = new LinkedHashMap();
        this.init();
    }

    private void init() {
        Object object = this.excelTemplate.getDetailLinkedField();
        int n = object.getRowIndex() + 1;
        int n2 = object.getColIndex();
        object = object.getSheetName();
        int n3 = this.workbookReader.getLastRowNum((String)object);
        ArrayList arrayList = new ArrayList();
        while (n <= n3) {
            Object object2 = this.workbookReader.getValue((String)object, n, n2, this.excelProcessContext);
            if (!StringUtil.isBlankOrNull((Object)object2) && !arrayList.contains(object2)) {
                this.mapInDoc.put(object2, new InDocument(object2, this.workbookReader));
            }
            ++n;
        }
        this.createInTables();
        this.docCollection = this.mapInDoc.values();
    }

    private void createInTables() {
        for (ExcelTemplateTable excelTemplateTable : this.excelTemplate.getTemplateTables4StampImport()) {
            Object object = excelTemplateTable.getSheetName();
            int n = this.workbookReader.getLastRowNum((String)object);
            int n2 = excelTemplateTable.getStartDtlRowIndex() + 1;
            IInputReader iInputReader = this.workbookReader.getSheetReader((String)object);
            ExcelTemplateField excelTemplateField = excelTemplateTable.getDetailLinkedField();
            for (int i = n2; i <= n; ++i) {
                object = iInputReader.getValue(i, excelTemplateField.getColIndex(), this.excelProcessContext);
                if (StringUtil.isBlankOrNull((Object)object) || !this.mapInDoc.containsKey(object)) continue;
                IInDocument<IInTable> iInDocument = this.mapInDoc.get(object);
                if ((object = (InTable4MultiBatch)iInDocument.getTable(excelTemplateTable.getTableKey())) == null) {
                    object = new InTable4MultiBatch(excelTemplateTable, this.workbookReader);
                    iInDocument.addTable((IInTable)object);
                }
                ((InTable4MultiBatch)object).addRowNum(i);
            }
        }
    }

    @Override
    public Iterator<IInDocument<IInTable>> iterator() {
        return new InDocumentListIterator(this.docCollection);
    }
}

