/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.excel.cmd.stamp.exportor;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.excel.cmd.normal.ExcelDataUtil;
import com.bokesoft.yes.excel.cmd.normal.ExcelStyleFactory;
import com.bokesoft.yes.excel.cmd.stamp.exportor.IDocumentExportor;
import com.bokesoft.yes.excel.document.ExcelDataTable;
import com.bokesoft.yes.excel.document.ExcelDetailDataRow;
import com.bokesoft.yes.excel.document.ExcelDocumentProcess;
import com.bokesoft.yes.excel.document.ExcelExpandDataRow;
import com.bokesoft.yes.excel.document.ExcelGroupDetailRow;
import com.bokesoft.yes.excel.document.GroupContext;
import com.bokesoft.yes.excel.document.IExcelDataRow;
import com.bokesoft.yes.excel.parser.ExcelContext;
import com.bokesoft.yes.excel.template.ColumnExpandItem;
import com.bokesoft.yes.excel.template.ExcelCell;
import com.bokesoft.yes.excel.template.ExcelDisplay;
import com.bokesoft.yes.excel.template.ExcelRow;
import com.bokesoft.yes.excel.template.ExcelSheet;
import com.bokesoft.yes.excel.template.ExcelWorkbook;
import com.bokesoft.yes.excel.template.util.ExcelUtil;
import com.bokesoft.yes.excel.transformer.ExcelTransformerFactory;
import com.bokesoft.yes.excel.transformer.IExcelTransformer;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelColumn;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelWorkbook;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.parser.IEvalContext;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.util.StampExcelUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFFormulaEvaluator;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class DocumentExportor4XmlTemplate
implements IDocumentExportor {
    private DefaultContext context = null;
    private ExcelContext excelContext = null;
    private Workbook workBook = null;
    private MetaExcelWorkbook metaWorkbook = null;
    private ExcelWorkbook virtualWorkbook = null;
    private ExcelTransformerFactory transformerFactory = null;
    private ExcelStyleFactory styleFactory = null;
    private Map<Integer, Integer> startMergeRowMap = new HashMap<Integer, Integer>();

    public DocumentExportor4XmlTemplate(MetaExcelWorkbook metaExcelWorkbook, DefaultContext defaultContext) {
        this.context = defaultContext;
        this.metaWorkbook = metaExcelWorkbook;
        this.workBook = new XSSFWorkbook();
        this.styleFactory = new ExcelStyleFactory(this.workBook);
        this.transformerFactory = new ExcelTransformerFactory();
    }

    public Workbook getWorkbook() {
        return this.workBook;
    }

    @Override
    public void export(Document document, String string) throws Throwable {
        this.excelContext = new ExcelContext(this.context);
        MetaDataObject metaDataObject = document.getMetaDataObject();
        this.context.setDocument(document);
        this.context.setFormKey(this.metaWorkbook.getFormKey());
        this.context.setDataObject(metaDataObject);
        this.excelContext.setDocument(document);
        this.virtualWorkbook = new ExcelWorkbook(metaDataObject, this.metaWorkbook, this.context.getMidParser());
        this.virtualWorkbook.calcExpandColumn(this.context.getMidParser(), document, metaDataObject);
        ExcelDocumentProcess excelDocumentProcess = new ExcelDocumentProcess(metaDataObject, this.virtualWorkbook, document, this.excelContext);
        excelDocumentProcess.process();
        Iterator<ExcelSheet> iterator = this.virtualWorkbook.iterator();
        while (iterator.hasNext()) {
            Object object;
            HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
            ExcelSheet excelSheet = iterator.next();
            Sheet sheet = ExcelUtil.getSheet((Workbook)this.workBook, (String)(StringUtil.isBlankOrNull((String)string) ? excelSheet.getName() : string));
            int n = 0;
            Iterator<ExcelRow> iterator2 = excelSheet.iterator();
            while (iterator2.hasNext()) {
                object = iterator2.next();
                switch (((ExcelRow)object).getType()) {
                    case 1: 
                    case 2: 
                    case 5: {
                        this.exportFixRow(document, metaDataObject, sheet, (ExcelRow)object, n, hashMap);
                        break;
                    }
                    case 3: 
                    case 6: {
                        n = this.exportDetailRow(excelDocumentProcess, document, metaDataObject, sheet, (ExcelRow)object, n, hashMap);
                    }
                }
            }
            object = excelSheet.columnIterator();
            while (object.hasNext()) {
                MetaExcelColumn metaExcelColumn = (MetaExcelColumn)object.next();
                int n2 = metaExcelColumn.getColumnIndex();
                n = (metaExcelColumn.getWidth() << 8) / 7;
                hashMap.put(n2 - 1, n);
            }
            ExcelUtil.setSheetColumnWidth((Sheet)sheet, hashMap);
        }
    }

    private int exportDetailRow(ExcelDocumentProcess object, Document object2, MetaDataObject metaDataObject, Sheet sheet, ExcelRow excelRow, int n, HashMap<Integer, Integer> hashMap) throws Throwable {
        this.excelContext.setExcelRow(excelRow);
        Object object3 = excelRow.getTableKey();
        object = ((ExcelDocumentProcess)object).getExcelDataTable((String)object3);
        if (object == null) {
            return n;
        }
        int n2 = excelRow.getRowIndex() - 1;
        int n3 = excelRow.getRowIndex();
        DataTable dataTable = object2.get((String)object3);
        metaDataObject = metaDataObject.getMetaTable((String)object3);
        this.excelContext.setDataTable(dataTable);
        this.excelContext.setMetaTable((MetaTable)metaDataObject);
        object3 = ((ExcelDataTable)object).iterator();
        int n4 = 0;
        HashMap<Integer, GroupContext> hashMap2 = new HashMap<Integer, GroupContext>();
        int n5 = 0;
        if (excelRow.getType() == 6) {
            Object object4;
            int n6 = n2 + n;
            for (int i = 0; i < excelRow.getCellCount(); ++i) {
                object4 = excelRow.getCell(i);
                if (!((ExcelCell)object4).getSourceType().equalsIgnoreCase("ExcelFormula")) continue;
                ((ExcelCell)object4).setExcelFormula(true);
                object2 = ((ExcelCell)object4).getDefinition();
                ((ExcelCell)object4).setExcelFormulaKey((String)object2);
                object2 = this.calcExcelFormula((ExcelCell)object4, (String)object2, (Iterator<IExcelDataRow>)object3, n3);
                ((ExcelCell)object4).setDefinition((String)object2);
            }
            object2 = ExcelUtil.getRow((Sheet)sheet, (int)n6);
            object2.setHeightInPoints((float)((short)excelRow.getHeight()));
            IExcelDataRow iExcelDataRow = ((ExcelDataTable)object).iterator().next();
            object4 = iExcelDataRow.getType();
            if ("Expand".equalsIgnoreCase((String)object4)) {
                this.fillExpandData((Row)object2, (ExcelExpandDataRow)iExcelDataRow, dataTable, excelRow, (MetaTable)metaDataObject, hashMap);
            } else if ("Detail".equalsIgnoreCase((String)object4)) {
                this.fillDetailData(sheet, n6, (ExcelDetailDataRow)iExcelDataRow, dataTable, excelRow, (MetaTable)metaDataObject, hashMap, hashMap2, 0);
            } else if ("GroupDetail".equalsIgnoreCase((String)object4)) {
                this.fillGroupData(sheet, n6, (ExcelGroupDetailRow)iExcelDataRow, dataTable, excelRow, (MetaTable)metaDataObject, hashMap, hashMap2, 0);
            }
            ++n;
            ++n4;
        } else {
            while (object3.hasNext()) {
                int n7 = n2 + n;
                object2 = ExcelUtil.getRow((Sheet)sheet, (int)n7);
                object2.setHeightInPoints((float)((short)excelRow.getHeight()));
                IExcelDataRow iExcelDataRow = (IExcelDataRow)object3.next();
                String string = iExcelDataRow.getType();
                if ("Expand".equalsIgnoreCase(string)) {
                    this.fillExpandData((Row)object2, (ExcelExpandDataRow)iExcelDataRow, dataTable, excelRow, (MetaTable)metaDataObject, hashMap);
                } else if ("Detail".equalsIgnoreCase(string)) {
                    this.fillDetailData(sheet, n7, (ExcelDetailDataRow)iExcelDataRow, dataTable, excelRow, (MetaTable)metaDataObject, hashMap, hashMap2, n5);
                } else if ("GroupDetail".equalsIgnoreCase(string)) {
                    this.fillGroupData(sheet, n7, (ExcelGroupDetailRow)iExcelDataRow, dataTable, excelRow, (MetaTable)metaDataObject, hashMap, hashMap2, n5);
                }
                ++n;
                ++n4;
                ++n5;
            }
        }
        hashMap2.clear();
        if (n4 > 0) {
            --n;
        }
        return n;
    }

    private String calcExcelFormula(ExcelCell excelCell, String string, Iterator<IExcelDataRow> iterator, int n) {
        int n2;
        Object object;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        Iterator<ExcelSheet> iterator2 = this.virtualWorkbook.iterator();
        while (iterator2.hasNext()) {
            object = iterator2.next();
            block4: for (n2 = 0; n2 < ((ExcelSheet)object).getRowCount(); ++n2) {
                ExcelRow excelRow = ((ExcelSheet)object).getRow(n2);
                switch (excelRow.getType()) {
                    case 3: {
                        for (int i = 0; i < excelRow.getCellCount(); ++i) {
                            ExcelCell excelCell2 = excelRow.getCell(i);
                            String string2 = excelCell2.getDefinition();
                            if (!string.endsWith(string2)) continue;
                            excelCell2.getCellIndex();
                            continue block4;
                        }
                        continue block4;
                    }
                }
            }
        }
        while (iterator.hasNext()) {
            n2 = ((ExcelDetailDataRow)iterator.next()).getRowIndex() + n;
            arrayList.add(n2);
        }
        int n3 = excelCell.getCellIndex();
        object = ExcelUtil.transToExcelNum(arrayList, (int)n3);
        return "SUM(" + (String)object + ")";
    }

    private void fillGroupData(Sheet sheet, int n, ExcelGroupDetailRow object, DataTable dataTable, ExcelRow object2, MetaTable metaTable, HashMap<Integer, Integer> hashMap, HashMap<Integer, GroupContext> object3, int n2) throws Throwable {
        GroupContext groupContext = new GroupContext();
        groupContext.addDefinition(((ExcelGroupDetailRow)object).getGroupLevel(), ((ExcelGroupDetailRow)object).getDefinition());
        ((HashMap)object3).put(n2, (GroupContext)groupContext);
        object3 = ((HashMap)object3).get(n2 - 1);
        this.excelContext.setDetailRows(((ExcelGroupDetailRow)object).getDetailRows());
        object = ((ExcelGroupDetailRow)object).getExcelRow().iterator();
        while (object.hasNext()) {
            object2 = (ExcelCell)object.next();
            if (((ExcelCell)object2).getCellIndex() == -1) continue;
            this.fillCellData(dataTable, metaTable, sheet, n, (ExcelCell)object2, hashMap, groupContext, (GroupContext)object3);
        }
    }

    private void fillDetailData(Sheet sheet, int n, ExcelDetailDataRow object, DataTable dataTable, ExcelRow object2, MetaTable metaTable, HashMap<Integer, Integer> hashMap, HashMap<Integer, GroupContext> object3, int n2) throws Throwable {
        this.excelContext.setExcelDetailDataRow((ExcelDetailDataRow)object);
        GroupContext groupContext = new GroupContext();
        groupContext.setDefinitionMap(((ExcelDetailDataRow)object).getDefinitionMap());
        ((HashMap)object3).put(n2, (GroupContext)groupContext);
        object3 = ((HashMap)object3).get(n2 - 1);
        dataTable.setPos(((ExcelDetailDataRow)object).getRowIndex());
        object = ((ExcelRow)object2).iterator();
        while (object.hasNext()) {
            object2 = (ExcelCell)object.next();
            this.fillCellData(dataTable, metaTable, sheet, n, (ExcelCell)object2, hashMap, groupContext, (GroupContext)object3);
        }
    }

    private void fillExpandData(Row row, ExcelExpandDataRow excelExpandDataRow, DataTable dataTable, ExcelRow object, MetaTable metaTable, HashMap<Integer, Integer> hashMap) throws Throwable {
        object = ((ExcelRow)object).iterator();
        while (object.hasNext()) {
            ExcelCell excelCell = (ExcelCell)object.next();
            Object object2 = excelCell.getDefinition();
            Object object3 = excelCell.getSourceType();
            boolean bl = false;
            int n = excelCell.getCellIndex() - 1;
            Cell cell = ExcelUtil.getCell((Row)row, (int)n);
            Object object4 = null;
            if (((String)object3).equalsIgnoreCase("field")) {
                object3 = excelCell.getColumnExpandTarget() ? this.findRowInExpandRow(dataTable, excelExpandDataRow, excelCell) : excelExpandDataRow.getRow(0);
                if (object3 != null) {
                    object2 = (MetaColumn)metaTable.get((String)object2);
                    object4 = dataTable.getObject(object3.getRowIndex(), object2.getKey());
                    object2 = this.transformerFactory.getTransformer(this.context, excelCell);
                    if (object2 != null) {
                        object4 = object2.transform(excelCell, object4);
                    }
                }
            } else if (((String)object3).equalsIgnoreCase("const")) {
                object4 = object2;
            } else if (((String)object3).equalsIgnoreCase("formula")) {
                this.excelContext.setExcelExpandDataRow(excelExpandDataRow);
                if (excelCell.getColumnExpandItems() != null && !excelCell.getColumnExpandItems().isEmpty()) {
                    this.excelContext.setExpandCount(excelCell.getColumnExpandItems().get(0).getExpandIndex());
                }
                object4 = this.excelContext.getMidParser().eval(0, (String)object2, (IEvalContext)this.excelContext, null);
            }
            if (object4 != null) {
                if (object4 instanceof BigDecimal) {
                    if (((BigDecimal)object4).compareTo(BigDecimal.ZERO) != 0) {
                        ExcelUtil.setCellValue((Cell)cell, (Object)object4);
                    }
                } else {
                    ExcelUtil.setCellValue((Cell)cell, (Object)object4);
                }
            }
            if ((object2 = excelCell.getDisplay()) != null) {
                bl = ((ExcelDisplay)object2).isWrapText();
            }
            if (bl) {
                this.styleFactory.getCellStyle(excelCell).setWrapText(bl);
            }
            cell.setCellStyle(this.styleFactory.getCellStyle(excelCell));
            ExcelUtil.calcMaxColumnWidth((Cell)cell, hashMap, (int)n);
        }
    }

    private IExcelDataRow findRowInExpandRow(DataTable dataTable, ExcelExpandDataRow excelExpandDataRow, ExcelCell object) {
        Object object2 = null;
        ArrayList<ColumnExpandItem> arrayList = ((ExcelCell)object).getColumnExpandItems();
        int n = excelExpandDataRow.size();
        for (int i = 0; i < n; ++i) {
            object = (ExcelDetailDataRow)excelExpandDataRow.getRow(i);
            boolean bl = true;
            for (ColumnExpandItem columnExpandItem : arrayList) {
                Object object3 = dataTable.getObject(((ExcelDetailDataRow)object).getRowIndex(), columnExpandItem.getKey());
                if (ExcelDataUtil.equals(columnExpandItem.getValue(), object3)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            object2 = object;
            break;
        }
        return object2;
    }

    private void exportFixRow(Document document, MetaDataObject metaDataObject, Sheet sheet, ExcelRow object, int n, HashMap<Integer, Integer> hashMap) throws Throwable {
        n = ((ExcelRow)object).getRowIndex() + n - 1;
        ExcelUtil.getRow((Sheet)sheet, (int)n).setHeightInPoints((float)((short)((ExcelRow)object).getHeight()));
        this.excelContext.setExcelRow((ExcelRow)object);
        Iterator<ExcelCell> iterator = ((ExcelRow)object).iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            String string = ((ExcelCell)object).getTableKey();
            MetaTable metaTable = metaDataObject.getMetaTable(string);
            string = document.get(string);
            this.fillCellData((DataTable)string, metaTable, sheet, n, (ExcelCell)object, hashMap, null, null);
        }
    }

    private void fillCellData(DataTable object, MetaTable metaTable, Sheet sheet, int n, ExcelCell excelCell, HashMap<Integer, Integer> hashMap, GroupContext groupContext, GroupContext groupContext2) throws Throwable {
        IExcelTransformer iExcelTransformer;
        short s;
        Object object2;
        int n2 = excelCell.getCellIndex() - 1;
        int n3 = excelCell.getMergedColumnSpan() - 1;
        int n4 = excelCell.getMergedRowSpan() - 1;
        boolean bl = false;
        String string = excelCell.getDefinition();
        Row row = ExcelUtil.getRow((Sheet)sheet, (int)n);
        String string2 = excelCell.getSourceType();
        Object object3 = null;
        if (string2.equalsIgnoreCase("field")) {
            object3 = excelCell.getColumnExpandTarget() ? (excelCell.getExpandCaption() == null ? excelCell.getExpandValue() : excelCell.getExpandCaption()) : object.getObject(string);
        } else if (string2.equalsIgnoreCase("const")) {
            object3 = string;
        } else if (string2.equalsIgnoreCase("formula")) {
            object3 = this.excelContext.getMidParser().eval(0, string, (IEvalContext)this.excelContext, null);
            object = string.split("\\(");
            object2 = object[0];
            if ("SumExpandPortrait".equalsIgnoreCase((String)object2)) {
                int n5 = this.excelContext.getExpandCount();
                if (n5 < ((Object)(object = ((String)object[1]).substring(((String)object[1]).indexOf("{") + 1, ((String)object[1]).lastIndexOf("}")).split(","))).length - 1) {
                    this.excelContext.setExpandCount(++n5);
                } else {
                    this.excelContext.setExpandCount(0);
                }
            }
        } else if (string2.equalsIgnoreCase("ExcelFormula")) {
            object3 = string;
        }
        object = excelCell.getDisplay();
        if (object != null) {
            bl = ((ExcelDisplay)object).isWrapText();
        }
        object2 = this.styleFactory.getCellStyle(excelCell);
        if (bl) {
            object2.setWrapText(bl);
        }
        Cell cell = ExcelUtil.getCell((Row)row, (int)n2);
        this.fillCellStyle(sheet, row, cell, n, n2, n4, n3, (CellStyle)object2);
        if (n3 > 0 || n4 > 0) {
            int n6 = n;
            int n7 = n2;
            sheet.addMergedRegionUnsafe(new CellRangeAddress(n6, n6 + n4, n7, n7 + n3));
        }
        if ((s = StampExcelUtil.getExcelCellStyle(excelCell, this.workBook)) != -1) {
            object2.setDataFormat(s);
        }
        if (!StampExcelUtil.isNumericCell(excelCell) && (iExcelTransformer = this.transformerFactory.getTransformer(this.context, excelCell)) != null) {
            object3 = iExcelTransformer.transform(excelCell, object3);
        }
        if (object3 != null) {
            if (string2.equalsIgnoreCase("ExcelFormula")) {
                cell.setCellFormula((String)object3);
                ((XSSFFormulaEvaluator)this.workBook.getCreationHelper().createFormulaEvaluator()).evaluateFormulaCell(cell);
            } else if (object3 instanceof BigDecimal) {
                if (((BigDecimal)object3).compareTo(BigDecimal.ZERO) != 0) {
                    ExcelUtil.setCellValue((Cell)cell, (Object)object3);
                }
            } else {
                ExcelUtil.setCellValue((Cell)cell, (Object)object3);
            }
        }
        if (groupContext != null) {
            groupContext.putDisplayValue(excelCell.getCellIndex(), TypeConvertor.toString((Object)object3));
        }
        this.mergeGroupCell(sheet, excelCell, n, n2, groupContext, groupContext2, string2, string, object3);
        if (!(n3 > 0) && !string2.equalsIgnoreCase("ExcelFormula")) {
            ExcelUtil.calcMaxColumnWidth((Cell)cell, hashMap, (int)n2);
        }
    }

    private void fillCellStyle(Sheet sheet, Row row, Cell cell, int n, int n2, int n3, int n4, CellStyle cellStyle) {
        if (!(n4 > 0 || n3 > 0)) {
            cell.setCellStyle(cellStyle);
            return;
        }
        for (int i = 0; i <= n4; ++i) {
            for (int j = 0; j <= n3; ++j) {
                ExcelUtil.getCell((Sheet)sheet, (int)(n + j), (int)(n2 + i)).setCellStyle(cellStyle);
            }
        }
    }

    private void mergeGroupCell(Sheet sheet, ExcelCell excelCell, int n, int n2, GroupContext object, GroupContext groupContext, String string, String string2, Object object2) {
        if (object == null) {
            return;
        }
        if (groupContext == null) {
            return;
        }
        if (string.equalsIgnoreCase("const")) {
            if (this.startMergeRowMap.containsKey(n2)) {
                int n3 = n2;
                sheet.addMergedRegion(new CellRangeAddress(this.startMergeRowMap.get(n2).intValue(), n - 1, n3, n3));
                this.startMergeRowMap.remove(n2);
            }
            return;
        }
        if (((GroupContext)object).getGroupLevel(string2) == null && !"FillGroup".equalsIgnoreCase((String)(object = string2.split("\\(")[0]))) {
            return;
        }
        int n4 = excelCell.getCellIndex();
        String string3 = groupContext.getDisplayValue(n4);
        if (string3 == null) {
            return;
        }
        if (!TypeConvertor.toString((Object)object2).equalsIgnoreCase(string3)) {
            if (this.startMergeRowMap.containsKey(n2)) {
                int n5 = n2;
                sheet.addMergedRegion(new CellRangeAddress(this.startMergeRowMap.get(n2).intValue(), n - 1, n5, n5));
                this.startMergeRowMap.remove(n2);
            }
            return;
        }
        if (!this.startMergeRowMap.containsKey(n2)) {
            this.startMergeRowMap.put(n2, n - 1);
        }
    }
}

