package com.bokesoft.yigo.util;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;

import com.bokesoft.yes.csv.cmd.normal.IExportPostProcess;
import com.bokesoft.yes.excel.cmd.stamp.dependency.DocumentDefaultFormulaEval;
import com.bokesoft.yes.excel.cmd.stamp.dependency.FormulaEvalGroup;
import com.bokesoft.yes.excel.cmd.stamp.dependency.FormulaEvalGroupIteratorBuilder;
import com.bokesoft.yes.excel.cmd.stamp.dependency.provider.IExpFieldItemProvider;
import com.bokesoft.yes.excel.cmd.stamp.dependency.provider.ImportExpFieldItemProvider;
import com.bokesoft.yes.excel.cmd.stamp.dependency.provider.StampExpFieldItemProvider;
import com.bokesoft.yes.excel.template.ExcelTemplate;
import com.bokesoft.yes.mid.base.SvrInfo;
import com.bokesoft.yes.tools.util.ReflectHelper;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.PageLoadType;
import com.bokesoft.yigo.common.def.TableMode;
import com.bokesoft.yigo.common.util.FileUtil;
import com.bokesoft.yigo.excel.IExportService;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.enhance.MetaEnhance;
import com.bokesoft.yigo.meta.enhance.MetaExportService;
import com.bokesoft.yigo.meta.enhance.MetaExtExportService;
import com.bokesoft.yigo.meta.enhance.MetaExtPostExportService;
import com.bokesoft.yigo.meta.enhance.MetaPostExportService;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListView;
import com.bokesoft.yigo.meta.form.component.grid.MetaGrid;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;

public class ExcelUtils {
	
	public static IExportService getExpService(DefaultContext context,String serviceName) throws Throwable{
		IExportService service = null;
		MetaExportService meta = null;
		if( serviceName != null && !serviceName.isEmpty() ) {
			MetaEnhance enhance = context.getVE().getMetaFactory().getEnhance(null);
			if( enhance != null ) {
				MetaExtExportService extService = enhance.getExtExportService();
				if ( extService != null ) {
					meta = extService.get(serviceName);
				}				
			}			
		}
		if( meta != null ) {
			service = (IExportService) ReflectHelper.newInstance(context.getVE(), meta.getImpl());
		}
		return service;
	}
	
	public static IExportPostProcess getPostExtProcess(DefaultContext context,String serviceName) throws Throwable {
		IExportPostProcess process = null;
		MetaPostExportService service = null;
		if( serviceName != null && !serviceName.isEmpty() ) {
			MetaEnhance enhance = context.getVE().getMetaFactory().getEnhance(null);
			if( enhance != null ) {
				MetaExtPostExportService extService = enhance.getPostExportService();
				if( extService != null ) {
					service = extService.get(serviceName);
				}
			}
		}
		if( service != null ) {
			process = (IExportPostProcess) ReflectHelper.newInstance(context.getVE(), service.getImpl());
		}
		return process;
	}
	
	public static String getExportFilePath(IMetaFactory metaFactory,String formKey) throws Throwable {
		String dirPath = metaFactory.getSolution().getDataPath();
		if (dirPath == null || dirPath.isEmpty()) {
			 dirPath = SvrInfo.getWorkDir();
		}
		dirPath = FileUtil.removeSlant(dirPath);
		return dirPath + File.separator + "Excel" + File.separator + formKey + File.separator
				+ formKey + System.currentTimeMillis() + ".xlsx";
	}
	
	public static String getExportFilePathByUUID(IMetaFactory metaFactory,String formKey) throws Throwable {
		String dirPath = metaFactory.getSolution().getDataPath();
		if (dirPath == null || dirPath.isEmpty()) {
			 dirPath = SvrInfo.getWorkDir();
		}
		dirPath = FileUtil.removeSlant(dirPath);
		return dirPath + File.separator + "Excel" + File.separator + formKey + File.separator
				+ formKey + UUID.randomUUID() + ".xlsx";
	}
	
	/**
	 * 获取文档对象中的id集合
	 * 
	 * @param doc
	 * @return
	 */
	public static List<Long> getOIDsFromDocument(Document doc) {
		String mainTableKey = doc.getMetaDataObject().getMainTableKey();
		MetaTable metaTable = doc.getMetaDataObject().getMetaTable(mainTableKey);
		DataTable dataTable = doc.get(mainTableKey);
		return getOIDs(dataTable, metaTable.getOIDColumn().getKey());
	}
	
	/**
	 * 获取table中的id
	 * @param dataTable
	 * @param idFieldKey
	 * @return
	 */
	public static List<Long> getOIDs(DataTable dataTable, String idFieldKey) {
		ArrayList<Long> lstIDs = new ArrayList<>();
		dataTable.beforeFirst();
		// 加载单据数据，批量导出
		while(dataTable.next(true)) {
			Long OID = dataTable.getLong(idFieldKey);
			lstIDs.add(OID);
		}
		return lstIDs;
	}
	
	// 目前未启用，需要客户端默认值计算统一到数据对象的数据表列中时，才能启用
	private final static boolean CALC_ON = false;
	
	/**
	 * 计算默认值公式
	 * 
	 * @param document
	 * @param excelTemplate
	 * @throws Throwable
	 */
	public static void calcDefaultFormula(Document document, ExcelTemplate excelTemplate, DefaultContext context) throws Throwable {
		if (!CALC_ON) return;
		Document oldDocument = context.getDocument();
		context.setDocument(document);
		MetaDataObject dataObject = document.getMetaDataObject();
		StampExpFieldItemProvider expFieldProvider = new StampExpFieldItemProvider(dataObject, excelTemplate);
		calcDefaultFormula(expFieldProvider, context);
		context.setDocument(oldDocument);
	}
	
	/**
	 * 计算默认值公式
	 * 
	 * @param document
	 * @param importFields
	 * @throws Throwable
	 */
	public static void calcDefaultFormula(Document document, HashMap<String, List<String>> importFields, DefaultContext context) throws Throwable {
		if (!CALC_ON) return;
		Document oldDocument = context.getDocument();
		context.setDocument(document);
		MetaDataObject dataObject = document.getMetaDataObject();
		ImportExpFieldItemProvider expFieldProvider = new ImportExpFieldItemProvider(dataObject, importFields);
		calcDefaultFormula(expFieldProvider, context);
		context.setDocument(oldDocument);
	}
	
	/**
	 * 计算默认值公式
	 * 
	 * @param document
	 * @param expFieldProvider
	 * @throws Throwable
	 */
	private static void calcDefaultFormula(IExpFieldItemProvider expFieldProvider, DefaultContext context) throws Throwable {
		if (!CALC_ON) return;
		FormulaEvalGroupIteratorBuilder evalGroupIteratorBuilder = new FormulaEvalGroupIteratorBuilder();
		Iterator<FormulaEvalGroup> evalGroupIterator = evalGroupIteratorBuilder.build(expFieldProvider);
		DocumentDefaultFormulaEval documentEval = new DocumentDefaultFormulaEval(context.getDocument(), context.getMidParser());
		documentEval.evalFormula(evalGroupIterator);
	}
	
	public static boolean isNeedLoadData(MetaForm metaForm, List<MetaTable> tableList) {
		MetaTable metaTable = null;

		Iterator<MetaTable> itTables = tableList.iterator();
		while (itTables.hasNext()) {
			metaTable = itTables.next();
			int tableModel = metaTable.getTableMode();
			switch (tableModel) {
			case TableMode.DETAIL:
				MetaComponent metaComponent = metaForm.findComponentByTable(metaTable.getKey());
				if( metaComponent == null )
					break;
				switch (metaComponent.getControlType()) {
				case ControlType.GRID:
					MetaGrid metaGrid = (MetaGrid)metaComponent;
					if( metaGrid.getPageLoadType() == PageLoadType.DB ) {
						return true;
					}
					break;
				case ControlType.LISTVIEW:
					MetaListView metaListView = (MetaListView)metaComponent;
					if( metaListView.getPageLoadType() == PageLoadType.DB ) {
						return true;
					}
					break;
				}
			}
		}
		return false;
	}
}