package com.bokesoft.yes.report;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

import com.bokesoft.yes.common.util.DateUtil;
import com.bokesoft.yes.report.proxy.IQueryProxy;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.mid.query.DBNamedQuery;
import com.bokesoft.yigo.struct.datatable.DataTable;

public class MidQueryProxy implements IQueryProxy {
	private DefaultContext context = null;
	private String formKey = null;
	public MidQueryProxy(DefaultContext context, String formKey) {
		this.context = context;
		this.formKey = formKey;
	}
	
	@Override
	public DataTable dbNamedQuery(String name, List<Object> args) throws Throwable {
		DBNamedQuery query = new DBNamedQuery(context, this.formKey, name, args);
		return query.exec();
	}

	@Override
	public Object dbNamedQueryValue(String name, List<Object> args) throws Throwable {
		DBNamedQuery query = new DBNamedQuery(context, this.formKey, name, args);
		DataTable table = query.exec();
		Object result = null;
		if (table.first()) {
			result = table.getObject(0, 0);
		}
		return result;
	}

	@Override
	public Date getServerDate() throws Throwable {
		Date date = DateUtil.getNowTime();
		SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		String val = format.format(date);
		return format.parse(val);
	}

	@Override
	public Date getDBDate() throws Throwable {
		IDBManager manager = context.getDBManager();
		long time = manager.getCurTime();
		java.sql.Date date = new java.sql.Date(time);
		SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		String val = format.format(date);
		return format.parse(val);
	}

}
