//package com.bokesoft.yes.excel.utils;
//
//import java.util.ArrayList;
//import java.util.HashMap;
//
//import org.apache.poi.ss.usermodel.Sheet;
//import org.apache.poi.ss.usermodel.Workbook;
//
//import com.bokesoft.yes.common.util.DBTypeUtil;
//import com.bokesoft.yes.tools.dic.proxy.IDictCacheProxy;
//import com.bokesoft.yigo.common.def.DictStateMask;
//import com.bokesoft.yigo.common.util.TypeConvertor;
//import com.bokesoft.yigo.meta.dataobject.MetaColumn;
//import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
//import com.bokesoft.yigo.meta.dataobject.MetaTable;
//import com.bokesoft.yigo.mid.base.DefaultContext;
//import com.bokesoft.yigo.struct.datatable.DataTable;
//import com.bokesoft.yigo.struct.dict.Item;
//import com.bokesoft.yigo.struct.document.Document;
//import com.bokesoft.yigo.tools.document.DocumentUtil;
//
//public class ImportBillHander {
//	private String dataObjectKey = null;
//
//	private HashMap<String, ArrayList<String>> importFields = null;
//
//	private Workbook workbook = null;
//
//	private Sheet mainSheet = null;
//
//	private MetaDataObject metaDataObject = null;
//
//	private DefaultContext context = null;
//	
//	private String formKey = null;
//	
//	public static String SEPARATOR = ";";
//
//	public ImportBillHander(DefaultContext context, Workbook workbook) throws Throwable {
//		this.workbook = workbook;
//		this.context = context;
//		init(context);
//	}
//
//	private void init(DefaultContext context) throws Throwable {
//		formKey = context.getFormKey();
//		// 第一个sheet中存储ItemKey
//		mainSheet = workbook.getSheetAt(0);
//		dataObjectKey = ExcelUtil.getCellValue(mainSheet, 0, 0).toString();
//		metaDataObject =context.getVE().getMetaFactory().getDataObject(dataObjectKey);
//
//		Sheet sheet = null;
//		String tableKey = null;
//		ArrayList<String> list = null;
//		importFields = new HashMap<String, ArrayList<String>>();
//		int sheetCount = workbook.getNumberOfSheets();
//		for (int i = 0; i < sheetCount; i++) {
//			sheet = workbook.getSheetAt(i);
//			tableKey = sheet.getSheetName();
//			list = new ArrayList<String>();
//			importFields.put(tableKey, list);
//
//			int colIndex = 1;
//			while (true) {
//				String fieldKey = ExcelUtil.getCellValue(sheet, 0, colIndex).toString();
//				if (fieldKey.isEmpty()) {
//					break;
//				}
//				list.add(fieldKey);
//				colIndex++;
//			}
//		}
//	}
//
//	public String getDataObjectKey() {
//		return dataObjectKey;
//	}
//
//	public MetaDataObject getDataObject() {
//		return metaDataObject;
//	}
//
//	public HashMap<String, ArrayList<String>> getImportFields() {
//		return importFields;
//	}
//
//	public ArrayList<String> getFieldsByTable(String tableKey) {
//		return importFields.get(tableKey);
//	}
//
//	public Document createNewDocumnt() throws Throwable {
//		Document document = DocumentUtil.newDocument(metaDataObject);
//		document.setNew();
//		return document;
//	}
//
//	public Sheet getMainSheet() throws Throwable {
//		return mainSheet;
//	}
//
//	// 填充导入的字段
//	public void fillImportField(MetaTable metaTable, DataTable dataTable, Sheet sheet, int rowIndex) throws Throwable {
//		ArrayList<String> fields = getFieldsByTable(metaTable.getKey());
//		for (int colIndex = 0; colIndex < fields.size(); colIndex++) {
//			String columnKey = fields.get(colIndex);
//			String[] columnKeys = columnKey.split(ImportDictionaryHander.SEPARATOR);
//			
//			Object value = getValue(metaTable, sheet, rowIndex, colIndex + 1, columnKey);
//			
//			
//			dataTable.setObject(columnKeys[0], value);
//		}
//	}
//
//	// 从Excel中获取导入的值，根据字段类型做转换
//	private Object getValue(MetaTable metaTable, Sheet sheet, int rowIndex, int colIndex, String fieldKey) throws Throwable {
//		Object value = ExcelUtil.getCellValue(sheet, rowIndex, colIndex);
//		String[] fields = fieldKey.split(ImportDictionaryHander.SEPARATOR);
//		String columnKey = fields[0];
//		if (fields.length > 1) {
//			String itemKey = fields[1];
//			IDictCacheProxy dictCache = (IDictCacheProxy) context.getVE().getDictCache();
//			Item item = dictCache.locate(itemKey, "Code", value.toString().toUpperCase(), null, null, DictStateMask.All);
//			value = item == null ? 0 : item.getID();
//		}
//
//		// 根据数DataType转型
//		MetaColumn column = metaTable.get(columnKey);
//		int dataType = column.getDataType();
//		value = TypeConvertor.toJavaType(DBTypeUtil.dataType2JavaDataType(dataType), value);
//
//		return value;
//	}
//	
//	public String getPrimayKey(Sheet sheet, int rowIndex, boolean isMainTable) {
//		return ExcelUtil.getCellValue(sheet, rowIndex, 0).toString();
//	}
//
//	public String getFormKey() {
//		return formKey;
//	}
//
//	public void setFormKey(String formKey) {
//		this.formKey = formKey;
//	}
//}
