package com.bokesoft.yes.excel.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;

import org.apache.poi.ss.usermodel.Workbook;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.struct.filedata.FileData;


public class ExcelFileUtil {
	
	/**
	 * 下载文件,设计器中处理为复制文件
	 * 
	 * @param filePath
	 * @param savePath
	 * @param fileMD5
	 * @return
	 * @throws Exception
	 */
	public static boolean downLoadFile(String filePath, String savePath, String fileMD5) throws Exception {
		// 直接复制,并删除源文件
		File file = new File(filePath);
		File saveFile = new File(savePath);

		if (!file.exists()) {
			return false;
		}

		if (!saveFile.exists()) {
			saveFile.createNewFile();
		}

		FileInputStream inputStream = new FileInputStream(file);
		FileOutputStream outputStream = new FileOutputStream(saveFile);

		byte[] b = new byte[1024];
		int len = inputStream.read(b);
		while (len != -1) {
			outputStream.write(b, 0, len);
			len = inputStream.read(b);
		}

		inputStream.close();
		outputStream.close();

		file.delete();

		return true;
	}
	
	public static FileData writeExcel(Workbook workbook, String sExportFileName) throws Throwable {
		return writeExcel(workbook, sExportFileName, true);
	}
	
	public static FileData writeExcel(Workbook workbook, String sExportFileName, boolean needCloseWorkbook)
			throws Throwable {
		FileOutputStream out = null;
		FileInputStream fis = null;
		FileData fileData = null;
		if (!sExportFileName.trim().endsWith(".xlsx") && !sExportFileName.trim().endsWith(".xls")) {
			sExportFileName = (sExportFileName + ".xlsx").trim();
		}
		File file = new File(sExportFileName);
		
		try {
			File parent = file.getParentFile();
			if( parent != null ) {
				parent.mkdirs();
			}
			
			out = new FileOutputStream(sExportFileName);
			workbook.write(out);
			out.flush();
			
			fis = new FileInputStream(sExportFileName);
			byte[] data = new byte[fis.available()];
			int i = 0;
			int n = fis.read();
			while(n != -1){
				data[i] = (byte)n;
				i++;
				n=fis.read();
			}
			
			fileData = new FileData();
			fileData.setData(data);
			fileData.setFileName(sExportFileName);
			
		} catch (Throwable e) {
			e.printStackTrace();
		} finally {
			if (needCloseWorkbook && workbook != null) {
				workbook.close();
			}
			if (needCloseWorkbook && out != null) {
				out.close();
			}
			if (needCloseWorkbook && fis != null) {
				fis.close();
			}
		}
		return fileData;
	}
	
	public static String getExportFileName(String formKey, String userFileName, String fileSuffix) {
		String fileName = StringUtil.isBlankOrStrNull(userFileName) ? formKey : userFileName;
		return fileName + fileSuffix;
	}
	
	public static FileData convertWorkbookToFileData(String formKey, String userFileName, Workbook workbook) throws Throwable {
		XlsxToFileDataUtil fileDataConvertor = new XlsxToFileDataUtil();
		String outFileName = ExcelFileUtil.getExportFileName(formKey, userFileName, ".xlsx");
		FileData result = fileDataConvertor.convertToFileData(outFileName, workbook);
		return result;
	}
	
	public static FileData convertCsvToFileData(String formKey, String userFileName, File csvFile) throws Throwable {
		Csv2FileDataUtil fileDataConvertor = new Csv2FileDataUtil();
		String outFileName = ExcelFileUtil.getExportFileName(formKey, userFileName, ".csv");
		FileData result = fileDataConvertor.convertToFileData(outFileName, csvFile);
		return result;
	}
}