package com.bokesoft.yes.excel.transformer;

import com.bokesoft.yigo.common.util.TypeConvertor;

public class StringFormatter  implements IDataFormatter{

	private static StringFormatter instance = null;

	private StringFormatter() {
	}
	
	@Override
	public String format(Object data, String sformat) {
		if (sformat == null || sformat.length() == 0) {
			return TypeConvertor.toString(data);
		}
		return String.format(sformat, data);
	}

	public static StringFormatter getInstance() {
		if(instance == null) {
			instance = new StringFormatter();
		}
		return instance;
	}
}
