package com.bokesoft.yes.excel.transformer;

import com.bokesoft.yigo.meta.exceltemplate.ExcelFormatDataType;

public class FormatterManager {

	/**
	 * 获取数据格式化方式
	 * @param type ReportFormatDataType
	 * @return
	 */
	public static IDataFormatter getDataFormatter(int type) {
		switch (type) {
		case ExcelFormatDataType.Number:
		case ExcelFormatDataType.Money:
			return NumberFormatter.getInstance();
		case ExcelFormatDataType.Text:
		case ExcelFormatDataType.Dict:
		case ExcelFormatDataType.List:
		case ExcelFormatDataType.MultiList:
			return StringFormatter.getInstance();
		case ExcelFormatDataType.Date:
			return DateFormatter.getInstance();
		}
		return StringFormatter.getInstance();
	}
}
