package com.bokesoft.yes.excel.transformer;

import java.util.List;

import com.bokesoft.yes.excel.template.ExcelCell;
import com.bokesoft.yes.excel.template.ExcelDisplay;
import com.bokesoft.yes.excel.template.ExcelFormat;
import com.bokesoft.yes.excel.template.ExcelListItem;


public class ExcelDefaultDataTransformer implements IExcelTransformer {

	@Override
	public Object transform(ExcelCell cell, Object value) {
		if (value == null) return value;
		Object result = value;
		ExcelDisplay display = cell.getDisplay();
		if ( display != null && value != null) {
			ExcelFormat format = display.getFormat();
			if ( format != null ) {
				return transform(format.getDataType(), format.getItemKey(), format.getFieldKeys(), format.getFormatString(), format.getListItems(), value);
			}
		}
		return result;
	}

	@Override
	public Object transform(int dataType, String itemKey, String fieldKeys, String formatString, List<ExcelListItem> listItems, Object value) {
		IDataFormatter formatter = FormatterManager.getDataFormatter(dataType);
		return formatter.format(value, formatString);
	}
}
