package com.bokesoft.yes.excel.template;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;

import com.bokesoft.yes.excel.document.ExcelGridInfo;
import com.bokesoft.yes.excel.document.GroupInfo;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.exceltemplate.ExcelTemplateRowType;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelColumn;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelColumns;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelRow;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelSheet;
import com.bokesoft.yigo.parser.IEval;
import com.bokesoft.yigo.struct.document.Document;

public class ExcelSheet {

	private String name = null;

	private IEval parser = null;
	
	private ArrayList<ExcelRow> excelRows = null;
	
	private ArrayList<MetaExcelColumn> metaExcelColumns = null;

	private HashMap<Integer, ExcelRow> excelRowMap = null;
	
	private HashMap<Integer, Integer> columnWidths = null;

	private ArrayList<ExcelGridInfo> gridInfoList = new ArrayList<ExcelGridInfo>();

	public ExcelSheet(MetaDataObject metaDataObject, MetaExcelSheet metaExcelSheet, IEval parser, boolean needResetCellIndex) {
		this.name = metaExcelSheet.getName();
		excelRows = new ArrayList<ExcelRow>();
		excelRowMap = new HashMap<Integer, ExcelRow>();
		metaExcelColumns = new ArrayList<MetaExcelColumn>();
		
		boolean inGrid = false;
		boolean hasColumnExpand = false;
		boolean hasGroup = false;
		boolean inGridDetail = false;
		int startRowIndex = -1;
		int lastRowIndex = -1;
		String tableKey = null;
		ArrayList<String> groupFieldList = new ArrayList<String>();
		TreeMap<Integer, GroupInfo> groupLevelMap = new TreeMap<Integer,GroupInfo>();

		// 将所有的列都加进虚拟sheet中
		ExcelRow excelRow = null;
		MetaExcelRow metaExcelRow = null;
		
		MetaExcelColumns columns = metaExcelSheet.getColumns();
		columnWidths = new HashMap<Integer, Integer>();
		if (columns != null) {
			Iterator<MetaExcelColumn> itColumns = columns.iterator();
			if (itColumns.hasNext()) {
				while (itColumns.hasNext()) {
					MetaExcelColumn metaExcelColumn = itColumns.next();
					int columnIndex = metaExcelColumn.getColumnIndex();
					int width = metaExcelColumn.getWidth();
					columnWidths.put(columnIndex - 1, width);
				}
			}
		}
		
		Iterator<MetaExcelRow> itExcelRow = metaExcelSheet.getRows().iterator();
		while (itExcelRow.hasNext()) {
			// 生成Excel模板对象
			metaExcelRow = itExcelRow.next();
			excelRow = new ExcelRow(metaExcelRow, parser, needResetCellIndex);
			excelRows.add(excelRow);
			excelRowMap.put(excelRow.getRowIndex(), excelRow);

			// 分析所有的行属性 添加表格信息
			int rowType = excelRow.getType();

			switch (rowType) {
			case ExcelTemplateRowType.DetailHead:
				if (inGridDetail) {
					// 如果已经有过明细行 说明上一个表格已经结束 开始下一个表格了
					addGridInfo(tableKey, startRowIndex, lastRowIndex, hasGroup, hasColumnExpand, groupFieldList, groupLevelMap);
					// 数据重置
					inGrid = false;
					tableKey = null;
					startRowIndex = -1;
					lastRowIndex = -1;
					hasGroup = false;
					hasColumnExpand = false;
				}
				if (!inGrid) {
					// 表格的第一行
					startRowIndex = excelRow.getRowIndex();
					hasColumnExpand = hasColumnExpand(excelRow);
					inGrid = true;
				}
				break;
			case ExcelTemplateRowType.Detail:
				tableKey = excelRow.getTableKey();
				inGridDetail = true;
				break;
			case ExcelTemplateRowType.Total:
				tableKey = excelRow.getTableKey();
				inGridDetail = true;
				break;
			case ExcelTemplateRowType.Group:
				hasGroup = true;
				recordGroupInfo(excelRow, groupFieldList, groupLevelMap);
				break;
			case ExcelTemplateRowType.Fix:
				break;
			case ExcelTemplateRowType.Head:
				if (inGrid) {
					// 说明上一个表格已经结束
					addGridInfo(tableKey, startRowIndex, lastRowIndex, hasGroup, hasColumnExpand, groupFieldList, groupLevelMap);
					// 数据重置
					tableKey = null;
					startRowIndex = -1;
					lastRowIndex = -1;
					hasGroup = false;
					hasColumnExpand = false;
					inGrid = false;
				}
				break;
			}
			
			if(!hasGroup) {
				lastRowIndex = excelRow.getRowIndex();
			}
		}

		MetaExcelColumn metaExcelColumn = null;
		MetaExcelColumns metaTempExcelColumns = metaExcelSheet.getColumns();
		if (metaTempExcelColumns != null){
			Iterator<MetaExcelColumn> itExcelColumn = metaTempExcelColumns.iterator();
			while (itExcelColumn.hasNext()) {
				metaExcelColumn = itExcelColumn.next();
				metaExcelColumns.add(metaExcelColumn);
			}
		}
		
		if (inGrid) {
			// 如果行循环完了还在表格标志还存在的话
			addGridInfo(tableKey, startRowIndex, lastRowIndex, hasGroup, hasColumnExpand, groupFieldList, groupLevelMap);
		}
	}

	private void addGridInfo(String tableKey, int startRowIndex,
			int lastRowIndex, boolean hasGroup, boolean hasColumnExpand, ArrayList<String> groupFieldList, TreeMap<Integer, GroupInfo> groupLevelMap) {
		ExcelGridInfo info = new ExcelGridInfo(tableKey, startRowIndex, lastRowIndex);
		info.setColumnExpand(hasColumnExpand);
		info.setHasGroup(hasGroup);
		if(hasGroup) {
			info.setGroupFieldList(groupFieldList);
			info.setGroupLevelMap(groupLevelMap);
		}

		gridInfoList.add(info);
	}

	private boolean hasColumnExpand(ExcelRow excelRow) {
		ExcelCell excelCell = null;
		Iterator<ExcelCell> itExcelCells = excelRow.iterator();
		while (itExcelCells.hasNext()) {
			excelCell = itExcelCells.next();
			if (excelCell.isColumnExpand()) {
				return true;
			}
		}

		return false;
	}
	
	private void recordGroupInfo(ExcelRow excelRow, ArrayList<String> groupFieldList, TreeMap<Integer, GroupInfo> groupLevelMap) {
		// 分组行的相关属性
		groupFieldList.add(excelRow.getGroupDefination());
		
		GroupInfo groupInfo = new GroupInfo(excelRow.getGroupLevel());
		groupInfo.setDefinition(excelRow.getGroupDefination());
		groupInfo.setGroupHeadRowCount(excelRow.getGroupHeadRowCount());
		groupInfo.setGroupPosition(excelRow.getGroupPosition());
		groupInfo.setGroupTailRowCount(excelRow.getGroupTailRowCount());
		groupInfo.setExcelRow(excelRow);
		groupLevelMap.put(excelRow.getGroupLevel(), groupInfo);
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public ExcelRow getRow(int index) {
		return excelRows.get(index);
	}

	public ExcelRow getRowByIndexInExcel(int index) {
		return excelRowMap.get(index);
	}

	public ExcelCell getCell(int rowIndex, int cellIndex) {
		return getRow(rowIndex).getCell(cellIndex);
	}

	public int getRowCount() {
		return excelRows.size();
	}
	
	public HashMap<Integer, Integer> getColumnWidths() {
		return columnWidths;
	}

	// 计算扩展列
	public void calcExpand(IEval parser, Document exportDocument, MetaDataObject metaDataObject)
			throws Throwable {
		for (ExcelGridInfo info : gridInfoList) {
			if (info.isColumnExpand()) {
				ExcelColumnExpandProcess process = new ExcelColumnExpandProcess(parser, info.getBeginRowIndex(), info.getEndRowIndex());
				process.process(this, exportDocument);
			}
		}
	}

	public ArrayList<ExcelGridInfo> getGridInfoList() {
		return gridInfoList;
	}
	
	public Iterator<MetaExcelColumn> columnIterator() {
		return metaExcelColumns.iterator();
	}
	
	public Iterator<ExcelRow> iterator() {
		return excelRows.iterator();
	}
}
