package com.bokesoft.yes.excel.template;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;

import com.bokesoft.yigo.common.def.ScriptType;
import com.bokesoft.yigo.meta.exceltemplate.ExcelTemplateColumnExpandSourceType;
import com.bokesoft.yigo.meta.exceltemplate.ExcelTemplateColumnExpandType;
import com.bokesoft.yigo.meta.exceltemplate.ExcelTemplateRowType;
import com.bokesoft.yigo.parser.IEval;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;

public class ExcelColumnExpandProcess {
	private IEval parser = null;

	private int beginRow = -1;

	private int endRow = -1;

	public ExcelColumnExpandProcess(IEval parser, int beginRow, int endRow) {
		this.parser = parser;
		this.beginRow = beginRow;
		this.endRow = endRow;
	}

	public void process(ExcelSheet excelSheet, Document exportDocument) throws Throwable {
		// 整合扩展区域
		ColumnExpandArray columnExpandArray = new ColumnExpandArray();
		extract(excelSheet, columnExpandArray, beginRow, endRow);

		// 处理扩展数据
		int size = columnExpandArray.getGroupCount();
		for (int i = 0; i < size; ++i) {
			ExcelColumnExpandCellGroup rootGroup = columnExpandArray.getGroup(i);
			rootGroup.calcCount();
			expandGroup(excelSheet, exportDocument, rootGroup);
		}
 
		processGridHeader(excelSheet, columnExpandArray);
	}

	// 处理表头扩展的合并单元格
	private void processGridHeader(ExcelSheet excelSheet, ColumnExpandArray columnExpandArray) {
		int size = columnExpandArray.getGroupCount();
		// 处理合并单元格
		for (int i = size - 1; i >= 0; --i) {
			ExcelColumnExpandCellGroup group = columnExpandArray.getGroup(i);
			// 处理合并单元格
			group.processMerge(excelSheet);
			
			LinkedList<ExcelCell> replaceCells = new LinkedList<ExcelCell>();
			for (int row = beginRow; row <= endRow; row++) {
				replaceCells.clear();
				int cellIndex = group.getCell().getCellIndex();
				group.getLeafCells(replaceCells, row);
				
				ExcelRow excelRow = excelSheet.getRowByIndexInExcel(row);
				excelRow.replace(cellIndex, group.getCount(), replaceCells, replaceCells.size());
			}
		}
	}

	private void expandGroup(ExcelSheet excelSheet, Document exportDocument, ExcelColumnExpandCellGroup rootGroup) throws Throwable {
		ExcelCell parentCell = rootGroup.getCell();
		ExcelColumnExpand columnExpand = parentCell.getColumnExpand();
		if (columnExpand != null && columnExpand.getExpandType() == ExcelTemplateColumnExpandType.Data) {
			impl_expandGroup(excelSheet, exportDocument, rootGroup);
		}

		// 向下循环所有的分组
		Iterator<IExcelColumnCellObject> it = rootGroup.iterator();
		IExcelColumnCellObject obj = null;
		while (it.hasNext()) {
			obj = it.next();
			if (obj.getObjectType() == IExcelColumnCellObject.Group) {
				this.expandGroup(excelSheet, exportDocument, (ExcelColumnExpandCellGroup) obj);
			}
		}
	}

	private int columnExpandIndexSeed = 0;

	private void impl_expandGroup(ExcelSheet excelSheet, Document exportDocument, ExcelColumnExpandCellGroup rootGroup) throws Throwable {
		LinkedList<IExcelColumnCellObject> tmpList = new LinkedList<IExcelColumnCellObject>();

		ExcelCell rootCell = rootGroup.getCell();
		ExcelColumnExpand columnExpand = rootCell.getColumnExpand();
		
		ArrayList<Object> values = new ArrayList<Object>();
		ArrayList<String> texts = new ArrayList<String>();

		switch (columnExpand.getSourceType()) {
		case ExcelTemplateColumnExpandSourceType.Data:
			String tableKey = rootCell.getTableKey();
			String columnKey = rootCell.getDefinition();
			
			DataTable dataTable = exportDocument.get(tableKey);
			int count = dataTable.size();
			for (int row = 0; row < count; row++) {
				Object o = dataTable.getObject(row, columnKey);
				if (!values.contains(o)) {
					values.add(o);
					texts.add(null);
				}
			}
			break;
		case ExcelTemplateColumnExpandSourceType.Custom:
			Object result = parser.eval(ScriptType.Formula, columnExpand.getContent(), null, null);
			if (result != null) {
				if (result instanceof String) {
					String s = (String) result;
					String[] v = s.split(";");
					int length = v.length;
					for (int j = 0; j < length; ++j) {
						String tmp = v[j];
						int commaPos = tmp.indexOf(',');
						String first = tmp.substring(0, commaPos);
						String second = tmp.substring(commaPos + 1);
						values.add(first);
						texts.add(second);
					}
				} else if (result instanceof DataTable) {
					DataTable sourceTable = (DataTable) result;
					sourceTable.beforeFirst();
					while (sourceTable.next()) {
						Object value = sourceTable.getObject(0);
						Object objCaption = sourceTable.getObject(1);
						String caption = objCaption == null ? "" : objCaption.toString();
						values.add(value);
						texts.add(caption);
					}
				}
			}
			break;
		}

		for (int i = 0, count = values.size(); i < count; ++i) {
			Object v = values.get(i);
			String t = texts.get(i);

			Iterator<IExcelColumnCellObject> it = rootGroup.iterator();
			IExcelColumnCellObject obj = null;
			while (it.hasNext()) {
				obj = it.next();
				IExcelColumnCellObject newObj = obj.clone();
				ColumnExpandItem columnExpandItem = new ColumnExpandItem();
				columnExpandItem.setRowIndex(rootGroup.getRowIndex());
				columnExpandItem.setCellIndexInExcel(rootGroup.getCell().getCellIndex());
				columnExpandItem.setValue(v);
				columnExpandItem.setText(t);
				columnExpandItem.setKey(rootCell.getDefinition());

				columnExpandItem.setExpandIndex(columnExpandIndexSeed++);
				newObj.traversalCell(columnExpandItem, new IExcelCellProcess() {

					@Override
					public void process(Object context, ExcelCell cell) {
						ColumnExpandItem item = (ColumnExpandItem) context;
						if (cell == null) { 
							return;
						}
						cell.addColumnExpandItem(item);
						if (cell.isColumnExpand()
								&& item.getRowIndex() == cell.getRowIndex()
								&& item.getCellIndexInExcel() == cell.getCellIndex()) {
							cell.setExpandCaption(item.getText());
							cell.setExpandValue(item.getValue());
						}
						cell.setColumnExpandTarget(true);
					}

				});

				tmpList.add(newObj);
			}
		}

		rootGroup.clear();
		rootGroup.addAll(tmpList);
	}

	private void extract(ExcelSheet excelSheet,
			ColumnExpandArray columnExpandArray, int beginRow, int endRow) {
		ExcelRow firstExcelRow = excelSheet.getRowByIndexInExcel(beginRow);
		int colCount = firstExcelRow.getCellCount();

		// 将第一行的扩展单元格 生成rootGroup加入集合并建立下属扩展信息
		for (int cellIndex = 0; cellIndex < colCount; ++cellIndex) {
			ExcelCell cell = firstExcelRow.getCell(cellIndex);
			if (cell.isColumnExpand()) {
				ExcelColumnExpandCellGroup group = new ExcelColumnExpandCellGroup();
				group.setCell(cell);
				group.setRowIndex(cell.getRowIndex());
				columnExpandArray.addGroup(group);

				buildColumnExpandGroup(excelSheet, group, beginRow, endRow);
			}
		}
	}

	private void buildColumnExpandGroup(ExcelSheet excelSheet,
			ExcelColumnExpandCellGroup rootGroup, int beginRow, int endRow) {
		int rowIndex = rootGroup.getRowIndex() + 1;
		ExcelCell excelCell = rootGroup.getCell();
		int cellIndexInExcel = excelCell.getCellIndex();
		int mergedColmnSpan = excelCell.getMergedColumnSpan();

		ExcelCell childExcelCell = null;
		ExcelRow excelRow = excelSheet.getRowByIndexInExcel(rowIndex);

		int rowType = excelRow.getType();
		if (rowType != ExcelTemplateRowType.DetailHead) {
			makeCellList(excelSheet, excelCell, rootGroup, beginRow, endRow);
			return;
		}

		for (int i = 0; i < mergedColmnSpan; ++i) {
			childExcelCell = excelRow.getCellByIndexInExcel(cellIndexInExcel + i);
			if (childExcelCell == null) {
				continue;
			}
			if (childExcelCell.isColumnExpand()) {
				ExcelColumnExpandCellGroup group = new ExcelColumnExpandCellGroup();
				group.setCell(childExcelCell);
				group.setRowIndex(childExcelCell.getRowIndex());
				rootGroup.add(group);
				buildColumnExpandGroup(excelSheet, group, beginRow, endRow);
			} else {
				// 不是扩展单元格
				makeCellList(excelSheet,childExcelCell, rootGroup, beginRow, endRow);
			}
		}
	}

	private void makeCellList(ExcelSheet excelSheet,ExcelCell childCell,
			ExcelColumnExpandCellGroup rootGroup, int beginRow, int endRow) {
		ExcelColumnExpandCellList list = new ExcelColumnExpandCellList();
		list.setCell(childCell);
		int cellIndex = childCell.getCellIndex();
		ExcelRow excelRow = null;
		ExcelCell excelCell = null;
		for (int rowindex = beginRow; rowindex <= endRow; ++rowindex) {
			excelRow = excelSheet.getRowByIndexInExcel(rowindex);
			excelCell = excelRow.getCellByIndexInExcel(cellIndex);

			list.add(excelCell);
		}
		rootGroup.add(list);
	}
}
