package com.bokesoft.yes.excel.template;

import com.bokesoft.yigo.meta.exceltemplate.ExcelCellBorderType;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelBorder;


public class ExcelBorder {
	/** 左边框线型 */
	private int leftStyle = ExcelCellBorderType.Border_None;
	/** 左边框颜色 */
	private String leftColor = "";
	/** 顶边框线形 */
	private int topStyle = ExcelCellBorderType.Border_None;
	/** 顶边框颜色 */
	private String topColor = "";
	/** 右边框线型 */
	private int rightStyle = ExcelCellBorderType.Border_None;
	/** 右边框颜色 */
	private String rightColor = "";
	/** 底边框线型 */
	private int bottomStyle = ExcelCellBorderType.Border_None;
	/** 底边框颜色 */
	private String bottomColor = "";

	private ExcelBorder() {}
	
	public ExcelBorder(MetaExcelBorder border) {
		this.leftStyle = border.getLeftStyle();
		this.leftColor = border.getLeftColor();
		this.topStyle = border.getTopStyle();
		this.topColor = border.getTopColor();
		this.rightStyle = border.getRightStyle();
		this.rightColor = border.getRightColor();
		this.bottomStyle = border.getBottomStyle();
		this.bottomColor = border.getBottomColor();
	}
	
	public void setLeftStyle(int leftStyle) {
		this.leftStyle = leftStyle;
	}

	public int getLeftStyle() {
		return this.leftStyle;
	}

	public void setLeftColor(String leftColor) {
		this.leftColor = leftColor;
	}

	public String getLeftColor() {
		return this.leftColor;
	}

	public void setTopStyle(int topStyle) {
		this.topStyle = topStyle;
	}

	public int getTopStyle() {
		return this.topStyle;
	}

	public void setTopColor(String topColor) {
		this.topColor = topColor;
	}

	public String getTopColor() {
		return this.topColor;
	}

	public void setRightStyle(int rightStyle) {
		this.rightStyle = rightStyle;
	}

	public int getRightStyle() {
		return this.rightStyle;
	}

	public void setRightColor(String rightColor) {
		this.rightColor = rightColor;
	}

	public String getRightColor() {
		return this.rightColor;
	}

	public void setBottomStyle(int bottomStyle) {
		this.bottomStyle = bottomStyle;
	}

	public int getBottomStyle() {
		return this.bottomStyle;
	}

	public void setBottomColor(String bottomColor) {
		this.bottomColor = bottomColor;
	}

	public String getBottomColor() {
		return this.bottomColor;
	}

	public ExcelBorder clone() {
		ExcelBorder newObject = new ExcelBorder();
		newObject.setLeftColor(leftColor);
		newObject.setTopColor(topColor);
		newObject.setRightColor(rightColor);
		newObject.setBottomColor(bottomColor);
		newObject.setLeftStyle(leftStyle);
		newObject.setTopStyle(topStyle);
		newObject.setRightStyle(rightStyle);
		newObject.setBottomStyle(bottomStyle);
		return newObject;
	}
	
	public String createStyleKey() {
		String key = leftStyle + "#" + leftColor + "#" + topStyle + "#" + topColor + "#" + rightStyle + "#" + rightColor
				+ "#" + bottomStyle + "#" + bottomColor;
		return key;
	}
}
