package com.bokesoft.yes.excel.service;

import java.util.HashMap;

import com.bokesoft.yes.data.cmd.ImportDataCmd;
import com.bokesoft.yes.excel.cmd.normal.ImportExcelCmd;
import com.bokesoft.yes.excel.cmd.normal.ImportExcelWithFormulaCmd;
import com.bokesoft.yes.excel.cmd.normal.SingleImportExcelCmd;
import com.bokesoft.yes.excel.cmd.stamp.ImportExcelWithStampCmd;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yes.mid.service.GeneralService;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.service.IServiceProvider;

public class DTSService extends GeneralService<DefaultContext> {
	@Override
	public String getServiceName() {
		return "DTS";
	}
	
	@Override
	protected Object[][] getCmdImplTable() {
		return new Object[][] {
				{ "ImportExcel", new ImportExcelCmd() },
				{ "SingleImportExcel", new SingleImportExcelCmd() },
				{ "ImportData", new ImportDataCmd() },
				{ "ImportExcelWithStamp", new ImportExcelWithStampCmd() },
				{ "ImportExcelWithFormula", new ImportExcelWithFormulaCmd() },
		};
	}

	@Override
	protected IServiceCmd<DefaultContext> getDefaultImpl() {
		return null;
	}

	@SuppressWarnings("unchecked")
	@Override
	public IServiceCmd<DefaultContext> getPrototype(DefaultContext context,
			String cmd) {
		return (IServiceCmd<DefaultContext>)DTSService.prototype.get(cmd);
	}
	
	private static HashMap<String, IServiceCmd<?>> prototype = null;
	static {
		DTSService.prototype = new HashMap<String, IServiceCmd<?>>();
		GeneralService.initPrototype(DTSService.prototype, new DTSService());
	}
	
	public IServiceProvider<DefaultContext> newInstance() {
		return new DTSService();
	}
}
