package com.bokesoft.yes.excel.document;

import java.util.ArrayList;
import java.util.Iterator;

public class ExcelExpandDataRow implements IExcelDataRow {
	private ArrayList<IExcelDataRow> detailRows = new ArrayList<IExcelDataRow>();
	
	public ExcelExpandDataRow() {
		
	}
	
	public void addDetailRow(IExcelDataRow row) {
		detailRows.add(row);
	}

	@Override
	public int getRowIndex() {
		return -1;
	} 
	
	public Iterator<IExcelDataRow> iterator() {
		return detailRows.iterator(); 
	}

	@Override
	public String getType() {
		return "Expand";
	}
	
	public IExcelDataRow getRow(int index) {
		return detailRows.get(index);
	}
	
	public int size() {
		return detailRows.size();
	}
}
