package com.bokesoft.yes.excel.cmd.stamp.output.strategy;

import java.util.HashMap;

import org.apache.poi.ss.usermodel.Workbook;

import com.bokesoft.yes.excel.cmd.stamp.output.process.OutputRowProcess;
import com.bokesoft.yes.excel.cmd.stamp.output.process.OutputSheetProcess;
import com.bokesoft.yes.excel.template.ExcelTemplate;
import com.bokesoft.yes.excel.template.ExcelTemplateField;
import com.bokesoft.yes.excel.template.constants.ExcelTemplateConstants;
import com.bokesoft.yes.excel.template.style.StampExcelStyleFactory;
import com.bokesoft.yes.excel.template.util.ExcelUtil;

/**
 * 多sheet批量导出
 * 
 * @author chenbb
 *
 */
public class MultiBatchOutputStrategy extends BaseOutputStrategy {
	// 下一个表单的导出起始位置
	//private int detailStartRowIndex = ExcelTemplateConstants.BATCH_START_DTL_ROW;
	// 记录当前导出到哪一行
	private int tempRowIndex = 0;
	// 是否为第一个表单
	//private boolean bFirstDoc = true;
	
	private HashMap<String, Integer> mapDetailStartRowIndex = null;
	
	public MultiBatchOutputStrategy(Workbook workbook, StampExcelStyleFactory styleFactory, ExcelTemplate excelSheetTemplate) {
		super(workbook, styleFactory, excelSheetTemplate);
		this.mapDetailStartRowIndex = new HashMap<>();
	}
	
	@Override
	public void insertRow(int sheetRowIndex, OutputRowProcess exportRowProcess) {
		int detailStartRowIndex = getDetailStartRowIndex();
		ExcelUtil.insertRow(curSheet, detailStartRowIndex + sheetRowIndex);
	}
	
	@Override
	public void outputCell(Object value, int rowIndex, int colIndex, ExcelTemplateField field, boolean isDtl) {
		// 非第一个数据对象的标题行不需要导出
		//if (!bFirstDoc && rowIndex == ExcelTemplateConstants.BATCH_TITLE_ROW) return;
		//if (!bFirstDoc) rowIndex -= 2; 
		int detailStartRowIndex = getDetailStartRowIndex();
		setCellValue(value, detailStartRowIndex + rowIndex, colIndex, field);
		tempRowIndex = Math.max(tempRowIndex, rowIndex);
	};
	
	@Override
	public void postOutputSheet(OutputSheetProcess exportSheetProcess) {
		String curSheetName = curSheet.getSheetName();
		int detailStartRowIndex = getDetailStartRowIndex();
		detailStartRowIndex += tempRowIndex + 1;
		mapDetailStartRowIndex.put(curSheetName, detailStartRowIndex);
		tempRowIndex = 0;
	};
	
	@Override
	public void postOutputExcel(ExcelTemplate templateTable) {
		//bFirstDoc = false;
	};
	
	protected void preMergedRegion(ExcelTemplateField templateField, int rowIndex, int colIndex) {
		
	}
	
	private int getDetailStartRowIndex() {
		if (!mapDetailStartRowIndex.containsKey(curSheet.getSheetName())) {
			mapDetailStartRowIndex.put(curSheet.getSheetName(), ExcelTemplateConstants.BATCH_START_DTL_ROW);
		}
		return mapDetailStartRowIndex.get(curSheet.getSheetName());
	}
}
