package com.bokesoft.yes.excel.cmd.stamp.input.reader.picture.storage;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.UUID;

import com.bokesoft.yes.common.storage.IStorageService;
import com.bokesoft.yes.excel.cmd.stamp.base.ExcelProcessContext;
import com.bokesoft.yigo.common.util.FileUtil;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.util.AttachmentUtils;
import com.bokesoft.yigo.struct.document.Document;

public class DefaultStorageService implements IStorageService {

	@Override
	public String save(byte[] data, String suggestFileExtension, Object ctx) {
		ExcelProcessContext excelContext = (ExcelProcessContext) ctx;
		Path path;
		try {
			Document document = excelContext.getCurDocument();
			path = saveFileData(data, excelContext.getFormKey(), document.getOID(), suggestFileExtension, excelContext.getMetaDataObject(), excelContext.getContext());
			return path.toString();
		} catch (Throwable e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "";
	}

	@Override
	public byte[] load(String path, Object ctx) {
		DefaultContext context = (DefaultContext) ctx;
		InputStream in = null;
		/*try {
			String dataPath = PrintPathUtil.getAttachDataPath(formKey, ve);
			IMetaFactory metaFactory = ve.getMetaFactory();
			if (StringUtil.isBlankOrNull(dataPath)) {
				in = metaFactory.loadResource("Data" + File.separatorChar + path);
			} else {
				String filePath = dataPath + File.separatorChar + path;
				File file = new File(filePath);
				if ( !file.exists() ) {
					return null;
				}
				in = new FileInputStream(file);
			}
			
		} catch (Throwable e1) {
			e1.printStackTrace();
		}*/
		return null;
	
	}
	
	private Path saveFileData(byte[] data, String formKey, long oid, String suggestFileExtension, MetaDataObject metaDataObject, DefaultContext context) throws Throwable {
		IMetaFactory metaFactory = context.getVE().getMetaFactory();
		String dataObjectKey = metaDataObject.getKey();
		// 图片的存储路径
		String dirPath = AttachmentUtils.getAttachDataPath(formKey, metaFactory);
		// 去掉多余'\'
		dirPath = FileUtil.removeSlant(dirPath);

		String fileName = UUID.randomUUID() + "." + suggestFileExtension;
		Path relativeFoldPath = Paths.get(dataObjectKey, "" + oid);
		Path absoluteFoldPath = Paths.get(dirPath, relativeFoldPath.toString());
		if (!Files.exists(absoluteFoldPath)) {
			Files.createDirectory(absoluteFoldPath);
		}
		Files.write(Paths.get(absoluteFoldPath.toString(), fileName), data, StandardOpenOption.CREATE);
		return Paths.get(relativeFoldPath.toString(), fileName);
	}
	
}
