package com.bokesoft.yes.excel.cmd.stamp.input.reader.picture.builder;

import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFPicture;
import org.apache.poi.hssf.usermodel.HSSFShape;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.ss.usermodel.PictureData;

import com.bokesoft.yes.excel.cmd.stamp.input.reader.picture.item.NormalPictureItem;
import com.bokesoft.yes.excel.cmd.stamp.input.reader.picture.struct.PictureSheet;

public class HSSFPictureSheetBuilder extends AbstractPictureSheetBuilder {
	
	@Override
	public PictureSheet build(Object oSheet) {
		HSSFSheet sheet = (HSSFSheet) oSheet;
		HSSFPatriarch drawingPatriarch = sheet.getDrawingPatriarch();
		if (drawingPatriarch != null && !CollectionUtils.isEmpty(drawingPatriarch.getChildren())) {
			List<HSSFShape> pictures = drawingPatriarch.getChildren();
			for (int i = 0; i < pictures.size(); i++) {
				HSSFShape shape = pictures.get(i);
				if (shape instanceof HSSFPicture) {
					HSSFPicture picture = (HSSFPicture) shape;
					HSSFClientAnchor anchor = (HSSFClientAnchor) picture.getAnchor();
					PictureData pdata = picture.getPictureData();
					short col1 = anchor.getCol1();
					int row1 = anchor.getRow1();
					addPictureItem(row1, col1, new NormalPictureItem(pdata));
				}
			}
		}
		return pictureSheet;
	}
	
}
