package com.bokesoft.yes.excel.cmd.stamp.input.reader;

import java.util.LinkedHashMap;

import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

import com.bokesoft.yes.excel.cmd.stamp.base.ExcelProcessContext;
import com.bokesoft.yes.excel.template.ExcelTemplate;
import com.bokesoft.yes.excel.template.ExcelTemplateSheet;

public class WorkbookReader implements IInputReaderBag {
	
	private Workbook workbook = null;
	
	private ExcelTemplate excelTemplate = null;
	
	private LinkedHashMap<String, IInputReader> mapReader = null;
	
	public WorkbookReader(Workbook workbook, ExcelTemplate excelTemplate) {
		this.workbook = workbook;
		this.excelTemplate = excelTemplate;
		this.mapReader = new LinkedHashMap<>();
		init();
		
	}
	
	private void init() {
		String sheetName = null;
		for (ExcelTemplateSheet templateSheet : excelTemplate.getTemplateSheets()) {
			sheetName = templateSheet.getSheetName();
			Sheet sheet = workbook.getSheet(sheetName);
			mapReader.put(sheetName, new SheetReader(sheet, templateSheet));
		}
	}
	
	@Override
	public Object getValue(String sheetName, int row, int col, ExcelProcessContext context) {
		IInputReader sheetReader = mapReader.get(sheetName);
		if (sheetReader == null) return null;
		return sheetReader.getValue(row, col, context);
	}

	@Override
	public boolean isEmptySheetRow(String sheetName, int rowIndex) {
		IInputReader sheetReader = mapReader.get(sheetName);
		if (sheetReader == null) return true;
		return sheetReader.isEmptySheetRow(rowIndex);
	}

	@Override
	public int getLastRowNum(String sheetName) {
		IInputReader sheetReader = mapReader.get(sheetName);
		if (sheetReader == null) return 0;
		return sheetReader.getLastRowNum();
	}

	@Override
	public IInputReader getSheetReader(String sheetName) {
		return mapReader.get(sheetName);
	}

	@Override
	public boolean isEmptyTableRow(String sheetName, String tableKey, int rowIndex) {
		IInputReader sheetReader = mapReader.get(sheetName);
		if (sheetReader == null) return true;
		return sheetReader.isEmptyTableRow(tableKey, rowIndex);
	}
	
	public void getLastCellIndex(String sheetName, int row) {
		IInputReader sheetReader = mapReader.get(sheetName);
	}
	
	@Override
	public int getLastCellNum(String sheetName, int rowIndex) {
		IInputReader sheetReader = mapReader.get(sheetName);
		return sheetReader.getLastCellNum(rowIndex);
	}


}
