package com.bokesoft.yes.excel.cmd.stamp.input.doc.out;

import java.util.LinkedHashMap;

import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;

public class OutDocument {

	private Document document = null;
	
	private LinkedHashMap<String, OutTable> mapOutTables = null; 
	
	public OutDocument(Document document) {
		this.document = document;
		this.mapOutTables = new LinkedHashMap<>();
		init();
	}
	
	public void init() {
		MetaTable metaTable = null;
		DataTable dataTable = null;
		int size = this.document.size();
		for (int index = 0; index < size; index ++) {
			dataTable = this.document.get(index);
			metaTable = this.document.getMetaDataObject().getMetaTable(dataTable.getKey());
			mapOutTables.put(dataTable.getKey(), new OutTable(dataTable, metaTable));
		}
	}

	public OutTable getTable(String tableKey) {
		return mapOutTables.get(tableKey);
	}
}
