package com.bokesoft.yes.excel.cmd.stamp.input.doc.in;

import com.bokesoft.yes.excel.cmd.stamp.base.ExcelProcessContext;
import com.bokesoft.yes.excel.cmd.stamp.input.doc.out.OutTable;
import com.bokesoft.yes.excel.cmd.stamp.input.process.action.IInputRowAction;
import com.bokesoft.yes.excel.cmd.stamp.input.reader.IInputReaderBag;
import com.bokesoft.yes.excel.template.ExcelTemplateTable;
import com.bokesoft.yigo.meta.dataobject.MetaTable;

/**
 * 虚拟数据表, 明细行连续
 * 
 * @author chenbb
 *
 */
public class InTable4Normal implements IInTable {
	
	private int startRowIndex, endRowIndex;

	private ExcelTemplateTable templateTable = null;
	
	private IInputReaderBag workbookReader = null;
	
	public InTable4Normal(ExcelTemplateTable templateTable, int startRowIndex, int endRowIndex, IInputReaderBag workbookReader) {
		this.templateTable = templateTable;
		this.startRowIndex = startRowIndex;
		this.endRowIndex = endRowIndex;
		this.workbookReader = workbookReader;
	}
	
	public ExcelTemplateTable getTemplateTable() {
		return this.templateTable;
	}
	
	@Override
	public String getKey() {
		return templateTable.getTableKey();
	}

	/**
	 * 获取数据结束行， 非明细表数据只存在一行
	 * @return
	 */
	private int getEndRow() {
		return templateTable.isDtlTable() ? this.endRowIndex : this.startRowIndex;
	}

	@Override
	public Object getValue(int row, int col, ExcelProcessContext context) {
		return workbookReader.getValue(templateTable.getSheetName(), row, col, context);
	}

	@Override
	public void doInputRowAction(OutTable outTable, IInputRowAction action, ExcelProcessContext context) throws Throwable {
		MetaTable metaTable = context.getMetaDataObject().getMetaTable(getKey());
		if (metaTable.isHead()) {
			action.doAction(this.getStartRowIndex(), this, outTable, templateTable, context);
		} else {
			for (int row = this.getStartRowIndex(); row <= this.getEndRow(); row ++) {
				action.doAction(row, this, outTable, templateTable, context);
			}
		}
	}

	@Override
	public int getStartRowIndex() {
		return startRowIndex;
	}
	
	@Override
	public boolean isEmptySheetRow(String sheetName, int row) {
		return workbookReader.isEmptySheetRow(sheetName, row);
	}

	@Override
	public boolean isEmptyTableRow(String sheetName, String tableKey, int row) {
		return workbookReader.isEmptyTableRow(sheetName, tableKey, row);
	}
}
