package com.bokesoft.yes.excel.cmd.stamp.input.doc.in;

import java.util.ArrayList;
import java.util.List;

import com.bokesoft.yes.excel.cmd.stamp.base.ExcelProcessContext;
import com.bokesoft.yes.excel.cmd.stamp.input.doc.out.OutTable;
import com.bokesoft.yes.excel.cmd.stamp.input.process.action.IInputRowAction;
import com.bokesoft.yes.excel.cmd.stamp.input.reader.IInputReaderBag;
import com.bokesoft.yes.excel.template.ExcelTemplateTable;

/**
 * 明细行通过关联字段和主表关联， 可以不连续
 * 
 * @author chenbb
 *
 */
public class InTable4MultiBatch implements IInTable {
	
	private List<Integer> listRows = null;
	
	private ExcelTemplateTable templateTable = null;
	
	private IInputReaderBag workbookReader = null;
	
	public InTable4MultiBatch(ExcelTemplateTable templateTable, IInputReaderBag workbookReader) {
		this.listRows = new ArrayList<>();
		this.templateTable = templateTable;
		this.workbookReader = workbookReader;
	}
	
	public ExcelTemplateTable getTemplateTable() {
		return this.templateTable;
	}
	
	@Override
	public String getKey() {
		return templateTable.getTableKey();
	}

	@Override
	public Object getValue(int row, int col, ExcelProcessContext context) {
		return workbookReader.getValue(templateTable.getSheetName(), row, col, context);
	}

	public void addRowNum(int rowNum) {
		if (!listRows.contains(rowNum)) {
			this.listRows.add(rowNum);
		}
	}
	
	@Override
	public void doInputRowAction(OutTable outTable, IInputRowAction action, ExcelProcessContext context) throws Throwable {
		for (Integer row : listRows) {
			action.doAction(row, this, outTable, templateTable, context);
		}
	}

	@Override
	public int getStartRowIndex() {
		if (this.listRows.size() == 0) return 0;
		return this.listRows.get(0);
	}

	@Override
	public boolean isEmptySheetRow(String sheetName, int row) {
		return workbookReader.isEmptySheetRow(sheetName, row);
	}

	@Override
	public boolean isEmptyTableRow(String sheetName, String tableKey, int row) {
		return workbookReader.isEmptyTableRow(sheetName, tableKey, row);
	}
	
}
