package com.bokesoft.yes.excel.cmd.stamp.input.doc.in;

import java.util.Collection;
import java.util.LinkedHashMap;

import com.bokesoft.yes.excel.cmd.stamp.input.reader.IInputReaderBag;

public class InDocument<T extends IInTable> implements IInDocument<T> {
	
	private T firstInTable = null;
	
	private Object primaryValue = null;
	
	private LinkedHashMap<String, T> mapTables = null; 
	
	public InDocument(Object primaryValue, IInputReaderBag workbookReader) {
		this.primaryValue = primaryValue;
		this.mapTables = new LinkedHashMap<>();
	}

	@Override
	public void addTable(T inTable) {
		if (firstInTable == null && inTable != null) {
			firstInTable = inTable;
		}
		this.mapTables.put(inTable.getKey(), inTable);
	}

	@Override
	public Collection<T> getInTables() {
		return mapTables.values();
	}

	@Override
	public T getTable(String key) {
		return mapTables.get(key);
	}

	@Override
	public int getDocumentStartRowIndex() {
		return firstInTable != null ? this.firstInTable.getStartRowIndex() : 0;
	}

	@Override
	public Object getPrimaryValue() {
		return primaryValue;
	}
}
