package com.bokesoft.yes.excel.cmd.stamp.dependency;

import java.util.Iterator;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.parser.SyntaxTree;
import com.bokesoft.yes.struct.document.DocumentParser;
import com.bokesoft.yigo.common.def.ScriptType;
import com.bokesoft.yigo.mid.base.BaseContext;
import com.bokesoft.yigo.parser.IEval;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;

/**
 * 计算document中部分字段的表达式
 * 
 * @author chenbb
 *
 */
public class DocumentDefaultFormulaEval {

	private Document document = null;
	
	private IEval<BaseContext> eval = null;
	
	/** 语法解析树的缓存 */
	private StringHashMap<SyntaxTree> syntaxTreeMap = new StringHashMap<SyntaxTree>();
	
	public DocumentDefaultFormulaEval(Document document, IEval<BaseContext> eval) {
		this.eval = eval;
		this.document = document;
		//this.eval = new DocumentParser(document, null);
	}
	
	/**
	 * 计算字段表达式
	 * 
	 * @param expFieldItems
	 * @throws Throwable
	 */
	public void evalFormula(Iterator<FormulaEvalGroup> evalGroupIterator) throws Throwable {
		FormulaEvalGroup formulaItemGroup = null;
		if (evalGroupIterator.hasNext()) {
			formulaItemGroup = evalGroupIterator.next();
			DataTable dataTable = document.get(formulaItemGroup.getKey());
			if (formulaItemGroup.isHead()) {
				dataTable.first();
				evalExpGroup(dataTable, formulaItemGroup);
			} else {
				dataTable.beforeFirst();
				while(dataTable.next()) {
					evalExpGroup(dataTable, formulaItemGroup);
				}
			}
		}
	}
	
	/**
	 * 执行表达式组中的公式
	 * 
	 * @param formulaItemGroup
	 * @throws Throwable
	 */
	private void evalExpGroup(DataTable dataTable, FormulaEvalGroup formulaItemGroup) throws Throwable {
		Object result = null;
		for (ExpFieldItem item : formulaItemGroup.getItems()) {
			result = eval(eval, item.getFormula());
			dataTable.setObject(item.getFieldKey(), result);
		}
	}
	
	/**
	 * 执行单个表达式
	 * 
	 * @param eval
	 * @param formula
	 * @return
	 * @throws Throwable
	 */
	private Object eval(IEval<?> eval, String formula) throws Throwable {
		SyntaxTree st = syntaxTreeMap.get(formula);
		if (st == null) {
			st = eval.parser(formula);
			syntaxTreeMap.put(formula, st);
		}
		return eval.eval(st);
	}
}

