package com.bokesoft.yes.excel.cmd.normal;

import java.io.ByteArrayInputStream;
import java.io.InputStream;

import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

import com.bokesoft.yes.excel.template.util.ExcelUtil;
import com.bokesoft.yigo.common.def.DataObjectPrimaryType;
import com.bokesoft.yigo.common.def.DataObjectSecondaryType;
import com.bokesoft.yigo.excel.IImportService2;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.base.MidCoreException;

public class ImportUtil {
	private DefaultContext context = null;
	private byte[] bytes = null;	
	private String formKey = null;
	
	private boolean clearOriginalData = false;
	
	private String postServiceName = null;
	
	private boolean isDocTypeDict = false;

	public ImportUtil(DefaultContext context, byte[] bytes){
		this.context = context;
		this.bytes = bytes;
	}
	
	public Object initImport() throws Throwable{
		DefaultContext newContext = new DefaultContext(context);
		newContext.setParas(context.getParas());
		//newContext.setFormKey(formKey);
		
		InputStream is = new ByteArrayInputStream(bytes);
		Workbook workbook = WorkbookFactory.create(is);
		MetaDataObject metaDataObject = getDataObject(newContext, workbook);
		int primaryType = metaDataObject.getPrimaryType();
		int secondaryType = metaDataObject.getSecondaryType();	
		IImport importData = null;
		if (primaryType == DataObjectPrimaryType.ENTITY) {
			switch(secondaryType) {
			case DataObjectSecondaryType.NORMAL:
				importData = (IImport)importExcel(newContext, workbook, postServiceName);
				break;
			case DataObjectSecondaryType.DICT:
			case DataObjectSecondaryType.CHAINDICT:
				if (isDocTypeDict){
					importData = (IImport)importDocTypeDict(newContext, workbook, postServiceName,clearOriginalData);
				}else{
					importData = (IImport)importDict(newContext, workbook,clearOriginalData, postServiceName);
				}
				break;	
			}
		}
		return importData;
	}
	
	private MetaDataObject getDataObject(DefaultContext context, Workbook workbook) throws Throwable {
		Sheet mainSheet = workbook.getSheetAt(0);
		String dataObjectKey = ExcelUtil.getCellValue(mainSheet, 0, 0).toString();
		MetaDataObject metaDataObject = context.getVE().getMetaFactory().getDataObject(dataObjectKey);
		if(metaDataObject == null){
			throw new MidCoreException(MidCoreException.DATAOBJECT_MISS, MidCoreException.formatMessage(null,MidCoreException.DATAOBJECT_MISS,dataObjectKey));
		}
		return metaDataObject;
	}

	//导入Excel
	private Object importExcel(DefaultContext newContext, Workbook workbook, String postServiceName){
		IImport importData = null;
		try {
			importData = new ImportExcel4Bill(newContext, workbook, postServiceName);
		} catch (Throwable e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return importData;
	};
	
	//导入字典(直接导入数据库)
	private Object importDict(DefaultContext newContext, Workbook workbook, boolean clearOriginalData, String postServiceName){
		IImport importData = null;
		try {
			importData = new ImportDictionary(newContext, workbook, clearOriginalData, postServiceName);
		} catch (Throwable e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return importData;
	};
	
	//导入字典(按docment方式导入)
	private Object importDocTypeDict(DefaultContext newContext, Workbook workbook, String postServiceName, boolean clearOriginalData){
		IImport importData = null;
		try {
			importData = new ImportDictionaryWithDoc(newContext, workbook, postServiceName,clearOriginalData);
		} catch (Throwable e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return importData;
	}
	
	public void setClearOriginalData(boolean clearOriginalData) {
		this.clearOriginalData = clearOriginalData;
	}
	
	public void setPostServiceName(String postServiceName) {
		this.postServiceName = postServiceName;
	}

	public void setFormKey(String formKey) {
		this.formKey = formKey;
	}
	
	public void setDocTypeDict(boolean isDocTypeDict){
		this.isDocTypeDict = isDocTypeDict;
	}
}
