package com.bokesoft.yes.excel.cmd.normal;

import com.bokesoft.yes.csv.cmd.normal.IExportPostProcess;
import com.bokesoft.yes.excel.utils.ExcelFileUtil;
import com.bokesoft.yes.struct.filedata.FileData;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.util.ExcelUtils;

public class BatchExportExcel implements IExport {
	// 批量导出的数据源表
	private DataTable dataTable;
	// 批量导出的数据源表中对应的OID字段
	private String OIDFieldKey;
	// 导出后事件服务名
	private String postExpServiceName;
	// 待导出的界面对象
	private MetaForm metaForm;
	// 上下文
	private DefaultContext context;
	// 待导出的单据的参数集合
	private ExportExcelParas paras;
	//自定义导出后的文件名(不包含后缀)
    private String exportFileName;
    
    private boolean needDownload = false;
	
	public BatchExportExcel(DefaultContext context, DataTable dataTable, String OIDFieldKey, String exportFormKey,
			String postExportServiceName, String exportFileName,boolean needDownload) throws Throwable {
		this.context = context;
		this.dataTable = dataTable;
		this.OIDFieldKey = OIDFieldKey;
		this.postExpServiceName = postExportServiceName;
		this.exportFileName=exportFileName;
		this.needDownload = needDownload;
		IMetaFactory metaFactory = context.getVE().getMetaFactory();
		metaForm = metaFactory.getMetaForm(exportFormKey);

		paras = new ExportExcelParas(context, metaForm);
	}

	@SuppressWarnings("deprecation")
	@Override
	public FileData exportData() throws Throwable {

		String relationalKey = paras.getRelationalKey();
		if (relationalKey == null || relationalKey.isEmpty()) {
			return null;
		}

		BatchExportTools tools = new BatchExportTools(metaForm, paras);
		tools.exportTitleData();

		dataTable.beforeFirst();
		// 加载单据数据，批量导出
		while (dataTable.next(true)) {
			Long OID = dataTable.getLong(OIDFieldKey);
			tools.exportSingleData(new DefaultContext(context), OID);
		}
		
		IMetaFactory metaFactory = context.getVE().getMetaFactory();
		
		String filePath = ExcelUtils.getExportFilePath(metaFactory, metaForm.getKey());
		
		FileData fileData = new FileData();
		if (!needDownload){				
			fileData = ExcelFileUtil.writeExcel(tools.getWorkbook(), filePath);
		}else{
			fileData = ExcelFileUtil.convertWorkbookToFileData(metaForm.getKey(), exportFileName, tools.getWorkbook());
		}
		IExportPostProcess process = ExcelUtils.getPostExtProcess(context, postExpServiceName);
		if( process != null ) {
			process.process(context, fileData);
		}

		if(needDownload){
			return fileData;
		}else{
			return new FileData();
		}
	}
}