package com.bokesoft.yes.excel.cmd.dee;

import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.dts.DataTransferService;
import com.bokesoft.yes.dts.data.DTSDataProvider;
import com.bokesoft.yes.dts.data.IDTSDataProvider;
import com.bokesoft.yes.dts.util.DTSUnZip;
import com.bokesoft.yes.mid.cmd.DefaultServiceCmd;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yes.tools.util.ReflectHelper;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.setting.MetaDTS;
import com.bokesoft.yigo.meta.setting.MetaDTSProvider;
import com.bokesoft.yigo.mid.base.DefaultContext;

public class ImportDEEDataCmd extends DefaultServiceCmd {

	private int transactionType;

	private String formKey;

	private String jsonString;
	
	private String providerKey;
	
	/**
	 * 传来的字符串是否需要解码解压缩
	 */
	private boolean needUnzip = true;
	
	public ImportDEEDataCmd(int transactionType, String formKey, String jsonString, String providerKey) {
		this.transactionType = transactionType;
		this.formKey = formKey;
		this.jsonString = jsonString;
		this.providerKey = providerKey;
//		this.needUnzip = true;
	}

	public ImportDEEDataCmd() {
	}

	public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
		transactionType = TypeConvertor.toInteger(arguments.get("transactionType"));
		formKey = TypeConvertor.toString(arguments.get("FormKey"));
		jsonString = TypeConvertor.toString(arguments.get("JsonString"));
		providerKey = TypeConvertor.toString(arguments.get("providerKey"));
		if(arguments.containsKey("needUnzip")) {
			needUnzip = TypeConvertor.toBoolean(arguments.get("needUnzip"));
		}
	}

	public Object doCmd(DefaultContext context) throws Throwable {
		IDTSDataProvider dtsDataBuilder = null;
		MetaDTS metaDts = context.getVE().getMetaFactory().getSetting().getDts();
		if(metaDts == null){
			LogSvr.getInstance().info("没有设置DTSProvider, 使用默认的provider");
			dtsDataBuilder = new DTSDataProvider();
		}
		else{
			if(providerKey.isEmpty() || providerKey == null ){
				providerKey = metaDts.getDefaultProvider();
			}
			LogSvr.getInstance().info("providerKey: "+ providerKey);
			MetaDTSProvider metaDtsProvider = metaDts.get(providerKey);
			if(metaDtsProvider == null){
				LogSvr.getInstance().info("找不到DTSProvider, 使用默认的provider");
				dtsDataBuilder = new DTSDataProvider();
			}
			else{
				dtsDataBuilder = (IDTSDataProvider) ReflectHelper.newInstance(context.getVE(), metaDtsProvider.getDriver());
			}
		}
		/*解码，解压缩*/
		String unzipString;
		if(needUnzip)
			unzipString = DTSUnZip.getJsonString(jsonString);
		else
			unzipString = jsonString;
		return DataTransferService.multiDataTransfer(context, dtsDataBuilder, unzipString, transactionType);
	}

	public IServiceCmd<DefaultContext> newInstance() {
		return new ImportDEEDataCmd();
	}

	public String getCmd() {
		return "Import";
	}
	
	public void notUnzip(){
		needUnzip = false;
	}
	
	@Override
	public boolean getNeedServiceRight(){
		return true;
	}
	
}
