package com.bokesoft.yes.dts;

import com.bokesoft.yigo.common.exception.CoreException;

public class DTSException extends CoreException
{
	private static final long serialVersionUID = 1L;
	
	/**
	 * 数据对象不存在
	 */
	public static final int NO_DATAOBJECT = 0x0001;
	
	/**
	 * 流程的processKey无效
	 */
	public static final int INVALID_PROCESSKEY= 0x0002;
	
	/*无效的值，用于参数检查*/
	public static final int INVALID_VALUE = 0x0003;
	/**
	 * 未知的操作类型
	 */
	public static final int UNKNOWN_OPERATION = 0x0004;
	
	/*需要插入的数据已经存在*/
	public static final int INSERT_EXIST = 0x0005;
	
	/*缺少主表*/
	public static final int NO_PRIMARY = 0x0007;
	
	/**
	 * 需要更新的数据对象没有找到 
	 */
	public static final int UPDATE_DATAOBJECT_NOT_EXIST = 0x0008;
	/**
	 * 需要更新的明细没有找到
	 */
	public static final int UPDATE_DETAIL_NOT_EXIST= 0x0010;
	
	/*找不到对应的列*/
	public static final int INVALID_COLUMN = 0x0009;
	
	/**
	 * 多个数据对象在关键字上重复
	 */
	public static final int DUPLICATE_DATAOBJECT = 0x000A;
	
	/*多行数据在关键字上重复*/
	public static final int DUPLICATE_DETAIL = 0x000B;
	
	/** 
	 * 业务关键字上没有数据 
	 */
	public static final int KEY_COLUMN_NODATA= 0x000C;
	
	/* 空表 */
	public static final int TABLE_EMPTY= 0x000D;
	
	/* 找不到表 */
	public static final int TABLE_NULL = 0x000E;
	
	/**
	 *  业务关键字无效 
	 */
	public static final int INVALID_KEY_COLUMN = 0x000F;
	
	
	
	public DTSException(int code, String message) {
		super(code, message);
	}

	@Override
	protected int getGroupCode() {
		return 0x8004;
	}
}
