package com.bokesoft.yes.data.service;

import java.util.Iterator;
import java.util.List;

import com.bokesoft.yes.excel.cmd.normal.LoadMultiPageDocument;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.document.LoadFormData;
import com.bokesoft.yigo.struct.condition.ConditionParas;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.struct.document.FilterMap;

public class DocumentService4IDs implements IDocumentService {
	
	protected String formKey = null;
	
	protected DefaultContext context = null;
	
	protected Iterator<Long> iteratorID = null;
	
	protected boolean needLoadMultiPage = false;
	
	protected FilterMap filterMap = null;
	
	protected ConditionParas condParas = null;
	
	@Override
	public void init(DefaultContext context, String formKey, Object ids, boolean needLoadMultiPage) {
		this.init(context, formKey, ids, needLoadMultiPage, null, null);
	}
	
	@Override
	public void init(DefaultContext context, String formKey, Object ids, boolean needLoadMultiPage, FilterMap filterMap, ConditionParas condParas) {
		this.context = context;
		this.formKey = formKey;
		this.needLoadMultiPage = needLoadMultiPage;
		//此做为兼容处理：next实现的未作处理
		this.filterMap = filterMap;
		this.condParas = condParas;
		List<Long> OIDList = (List<Long>) ids;
		iteratorID = OIDList.iterator();
	}


	@Override
	public String getDocumentTitle(Document document) {
		return "" + document.getOID();
	}

	@Override
	public boolean hasNext() {
		return iteratorID.hasNext();
	}

	@Override
	public Document next() {
		Long OID = iteratorID.next();
		try {
			DefaultContext newContext = new DefaultContext(context);
			if (this.needLoadMultiPage) {
				FilterMap filterMap = new FilterMap();
				filterMap.setOID(OID);
				LoadMultiPageDocument loadMultiPageDocument = new LoadMultiPageDocument(newContext, filterMap, null);
				MetaForm metaForm4Export = context.getVE().getMetaFactory().getMetaForm(formKey);
				Document document = loadMultiPageDocument.reloadDocument(metaForm4Export);
				return document;
			} else {
				LoadFormData load = new LoadFormData(formKey, OID);
				Document document = load.load(newContext, null);
				return document;
			}
		} catch (Throwable e) {
			e.printStackTrace();
		}
		return null;
	}
	
	@Override
	public IDocumentService newInstance() {
		return new DocumentService4IDs();
	}

	@Override
	public boolean check(DefaultContext context, String moduleName, String methodName, String formKey, Object extPara) {
		return true;
	}
}
