package com.bokesoft.yes.csv.cmd.normal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

import org.json.JSONObject;

import com.bokesoft.yes.common.util.ConstUtil;
import com.bokesoft.yes.excel.datatransfer.DataTransferUtil;
import com.bokesoft.yes.excel.template.util.ExcelUtil;
import com.bokesoft.yes.excel.utils.ExcelFileUtil;
import com.bokesoft.yes.mid.base.SvrInfo;
import com.bokesoft.yes.struct.filedata.FileData;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.ParameterSourceType;
import com.bokesoft.yigo.common.def.RowType;
import com.bokesoft.yigo.common.def.ScriptType;
import com.bokesoft.yigo.common.def.TableMode;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaParameter;
import com.bokesoft.yigo.meta.dataobject.MetaParameterCollection;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.editview.MetaEditView;
import com.bokesoft.yigo.meta.form.component.control.editview.MetaEditViewColumn;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListView;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListViewColumn;
import com.bokesoft.yigo.meta.form.component.grid.MetaGrid;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridCell;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridRow;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.document.LoadFormData;
import com.bokesoft.yigo.mid.util.DocumentUtil;
import com.bokesoft.yigo.mid.util.MD5Util;
import com.bokesoft.yigo.struct.condition.ConditionParas;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.struct.document.FilterMap;
import com.bokesoft.yigo.struct.document.TableFilterDetail;
import com.bokesoft.yigo.util.ExcelUtils;

public class ExportCSV {
	private static String EndingSymbol = "\n";

	private DefaultContext context = null;

	private Document document = null;

	private MetaForm metaForm = null;

	private String exportTable = null;

	private FilterMap filterMap = null;

	private ConditionParas condParameters = null;
	
	private boolean onlyCurrentPage = false;
	
	private String postExportServiceName = null;
	
    private String exportFileName=null; 
    
	private boolean needDownload = false;
	
	public ExportCSV(DefaultContext context, Document document, FilterMap filterMap, ConditionParas condParameters,
			MetaForm metaForm, String exportTable, boolean onlyCurrentPage, String postExportServiceName,String exportFileName,boolean needDownload) {
		this.context = context;
		this.document = document;
		this.filterMap = filterMap;
		this.metaForm = metaForm;
		this.exportTable = exportTable;
		this.condParameters = condParameters;
		this.onlyCurrentPage = onlyCurrentPage;
		this.postExportServiceName = postExportServiceName;
		this.exportFileName=exportFileName;
		this.needDownload = needDownload;
	}

	public FileData export() throws Throwable {
		FileOutputStream fos = null;
		OutputStreamWriter osw = null;
		File file = null;
		if (document == null) {
			return null;
		}

		String dirPath = SvrInfo.getWorkDir();
		String filePath = dirPath + File.separator + "CSV" + File.separator + metaForm.getKey()
				+ System.currentTimeMillis() + ".CSV";

		// 获取MetaDataObject
		MetaDataObject metaDataObject = metaForm.getDataSource().getDataObject();
		boolean exportAll = exportTable == null || exportTable.isEmpty();
		boolean needLoadData = false;

		ArrayList<MetaTable> tableList = new ArrayList<MetaTable>();
		if (exportAll) {
			Iterator<MetaTable> itTables = metaDataObject.getTableCollection().iterator();
			while (itTables.hasNext()) {
				tableList.add(itTables.next());
			}
		} else {
			String[] tableKeys = exportTable.split(",");
			for (String tableKey : tableKeys) {
				MetaTable metaTable = metaDataObject.getTable(tableKey);
				if (metaTable != null) {
					tableList.add(metaTable);
				}
			}
		}

		if (tableList.size() == 0) {
			return  new FileData();
		}

		MetaTable metaTable = null;
		DataTable dataTable = null;
	
		needLoadData = DocumentUtil.isPaginationForm(metaForm, tableList.iterator());
		Document exportDocument = document;
		try {
			if (needLoadData && !onlyCurrentPage) {
				processParameter(context, tableList);

				filterMap.setUseCursor(true);
				Iterator<TableFilterDetail> it = filterMap.values().iterator();
				while (it.hasNext()) {
					TableFilterDetail detail = it.next();
					if (detail != null) {
						detail.setMaxRows(0);
					}
				}

				LoadFormData loadData = new LoadFormData(metaForm.getKey(), filterMap, condParameters);
				exportDocument = loadData.load(context, null);
			} else {
				Iterator<MetaTable> itTables = tableList.iterator();
				while (itTables.hasNext()) {
					metaTable = itTables.next();
					exportDocument.get(metaTable.getKey()).beforeFirst();;
				}
			}

			file = new File(filePath);
			File parent = file.getParentFile();
			if (parent != null) {
				parent.mkdirs();
			}

			if (!file.exists()) {
				file.createNewFile();
			}

			fos = new FileOutputStream(file, true);
			osw = new OutputStreamWriter(fos, "gbk");

			Iterator<MetaTable> itTables = tableList.iterator();
			while (itTables.hasNext()) {
				metaTable = itTables.next();
				dataTable = exportDocument.get(metaTable.getKey());
				exportTable(osw, metaForm, metaTable, dataTable);
			}
		} catch (Throwable e) {
			e.printStackTrace();
		} finally {
			try {
				if (osw != null) {
					osw.close();
				}

				if (fos != null) {
					fos.close();
				}

				if (needLoadData) {
					exportDocument.close();
				}
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
		
		context.setDocument(exportDocument);
		
		FileData fileData = new FileData();	
		fileData = ExcelFileUtil.convertCsvToFileData(metaForm.getKey(), exportFileName, file);
		// 导出后自定义处理
		IExportPostProcess process = ExcelUtils.getPostExtProcess(context, postExportServiceName);
		if( process != null ) {
			process.process(context, fileData);
		}
		if(needDownload){
			return fileData;
		}else{
			return new FileData();
		}
	}

	private void exportTable(OutputStreamWriter osw, MetaForm metaForm, MetaTable metaTable, DataTable dataTable)
			throws Throwable {
		int tableModel = metaTable.getTableMode();
		switch (tableModel) {
		case TableMode.HEAD:
			exportHeadTable(osw, metaForm, metaTable, dataTable);
			break;
		case TableMode.DETAIL:
			exportDetailTable(osw, metaForm, metaTable, dataTable);
			break;
		}
	}

	private void exportDetailTable(OutputStreamWriter osw, MetaForm metaForm, MetaTable metaTable, DataTable dataTable)
			throws Throwable {
		String tableKey = metaTable.getKey();
		DataTable exportTable = dataTable;
		
		MetaComponent metaComponent = metaForm.findComponentByTable(tableKey);
		if( metaComponent == null )
			return; 
		switch (metaComponent.getControlType()) {
		case ControlType.GRID:
			exportGridTable(osw, metaForm, (MetaGrid) metaComponent, metaTable, exportTable);
			break;
		case ControlType.LISTVIEW:
			exportListViewTable(osw, metaForm, (MetaListView) metaComponent, metaTable, exportTable);
			break;
		case ControlType.EDITVIEW:
			exportEditViewTable(osw, metaForm, (MetaEditView) metaComponent, metaTable, exportTable);
			break;
		default:
			break;
		}
	}

	@SuppressWarnings("deprecation")
	private void exportListViewTable(OutputStreamWriter osw, MetaForm metaForm, MetaListView metaListView,
			MetaTable metaTable, DataTable dataTable) throws Throwable {
		// 记录ColumnKey和MetaComponent的关系
		HashMap<String, MetaListViewColumn> map = new HashMap<String, MetaListViewColumn>();
		// 先找到数据行
		MetaListViewColumn listViewColumn = null;
		Iterator<MetaListViewColumn> itListViewColumn = metaListView.getColumnCollection().iterator();
		while (itListViewColumn.hasNext()) {
			listViewColumn = itListViewColumn.next();
			map.put(listViewColumn.getDataColumnKey(), listViewColumn);
		}

		Object value = null;
		MetaColumn metaColumn = null;
		MetaListViewColumn metaListViewColumn = null;

		String exportHeader = "";
		String exportValue = "";

		// 循环所有数据行、数据列，有字段的才做导出
		int row = 0;
		while (dataTable.next(true)) {
			Iterator<MetaColumn> itMetaColumn = metaTable.iterator();
			while (itMetaColumn.hasNext()) {
				metaColumn = itMetaColumn.next();
				String columnKey = metaColumn.getKey();
				metaListViewColumn = map.get(columnKey);
				if (metaListViewColumn != null) {
					value = DataTransferUtil.convertFieldValue(context, metaForm, metaListViewColumn.getColumnType(),
							metaListViewColumn.getProperties(), dataTable, columnKey);
					value = CSVUtil.convertCSVValue(metaColumn, TypeConvertor.toString(value));
					exportValue += value + ",";

					if (row == 0) {
						exportHeader += CSVUtil.convertCSVValue(null, metaColumn.getCaption()) + ",";
					}
				}
			}

			if (row == 0) {
				osw.append(exportHeader + EndingSymbol);
			}
			osw.append(exportValue += EndingSymbol);
			exportValue = "";

			row++;
		}

		if (exportHeader.isEmpty()) {
			Iterator<MetaColumn> itMetaColumn = metaTable.iterator();
			while (itMetaColumn.hasNext()) {
				metaColumn = itMetaColumn.next();
				if (map.containsKey(metaColumn.getKey())) {
					exportHeader += CSVUtil.convertCSVValue(null, metaColumn.getCaption()) + ",";
				}
			}
			osw.append(exportHeader + EndingSymbol);
		}

		osw.append(EndingSymbol + EndingSymbol);
	}
	
	@SuppressWarnings("deprecation")
	private void exportEditViewTable(OutputStreamWriter osw, MetaForm metaForm, MetaEditView metaEditView,
			MetaTable metaTable, DataTable dataTable) throws Throwable {
		// 记录ColumnKey和MetaComponent的关系
		HashMap<String, MetaEditViewColumn> map = new HashMap<String, MetaEditViewColumn>();
		// 先找到数据行
		MetaEditViewColumn EditViewColumn = null;
		Iterator<MetaEditViewColumn> itEditViewColumn = metaEditView.getColumnCollection().iterator();
		while (itEditViewColumn.hasNext()) {
			EditViewColumn = itEditViewColumn.next();
			map.put(EditViewColumn.getDataColumnKey(), EditViewColumn);
		}

		Object value = null;
		MetaColumn metaColumn = null;
		MetaEditViewColumn metaEditViewColumn = null;

		String exportHeader = "";
		String exportValue = "";

		// 循环所有数据行、数据列，有字段的才做导出
		int row = 0;
		while (dataTable.next(true)) {
			Iterator<MetaColumn> itMetaColumn = metaTable.iterator();
			while (itMetaColumn.hasNext()) {
				metaColumn = itMetaColumn.next();
				String columnKey = metaColumn.getKey();
				metaEditViewColumn = map.get(columnKey);
				if (metaEditViewColumn != null) {
					value = DataTransferUtil.convertFieldValue(context, metaForm, metaEditViewColumn.getColumnType(),
							metaEditViewColumn.getProperties(), dataTable, columnKey);
					value = CSVUtil.convertCSVValue(metaColumn, TypeConvertor.toString(value));
					exportValue += value + ",";

					if (row == 0) {
						exportHeader += CSVUtil.convertCSVValue(null, metaColumn.getCaption()) + ",";
					}
				}
			}

			if (row == 0) {
				osw.append(exportHeader + EndingSymbol);
			}
			osw.append(exportValue += EndingSymbol);
			exportValue = "";

			row++;
		}

		if (exportHeader.isEmpty()) {
			Iterator<MetaColumn> itMetaColumn = metaTable.iterator();
			while (itMetaColumn.hasNext()) {
				metaColumn = itMetaColumn.next();
				if (map.containsKey(metaColumn.getKey())) {
					exportHeader += CSVUtil.convertCSVValue(null, metaColumn.getCaption()) + ",";
				}
			}
			osw.append(exportHeader + EndingSymbol);
		}

		osw.append(EndingSymbol + EndingSymbol);
	}

	@SuppressWarnings("deprecation")
	private void exportGridTable(OutputStreamWriter osw, MetaForm metaForm, MetaGrid metaGrid, MetaTable metaTable,
			DataTable dataTable) throws Throwable {
		// 记录ColumnKey和MetaComponent的关系
		HashMap<String, MetaGridCell> map = new HashMap<String, MetaGridCell>();
		// 先找到数据行
		Iterator<MetaGridRow> itRow = metaGrid.getRowCollection().iterator();
		MetaGridRow metaRow = null;
		MetaGridCell metaCell = null;
		while (itRow.hasNext()) {
			metaRow = itRow.next();
			if (metaRow.getRowType() == RowType.Detail) {
				Iterator<MetaGridCell> itCell = metaRow.iterator();
				while (itCell.hasNext()) {
					metaCell = itCell.next();
					if (metaTable.getKey().equals(metaCell.getTableKey())) {
						map.put(metaCell.getColumnKey(), metaCell);
					}
				}
			}
		}

		// 循环所有数据行、数据列，有字段的才做导出
		MetaColumn metaColumn = null;
		Object value = null;
		String exportHeader = "";
		String exportValue = "";
		int row = 0;
		while (dataTable.next(true)) {
			Iterator<MetaColumn> itMetaColumn = metaTable.iterator();
			while (itMetaColumn.hasNext()) {
				metaColumn = itMetaColumn.next();
				String columnKey = metaColumn.getKey();
				MetaGridCell metaGridCell = map.get(columnKey);
				if (metaGridCell != null) {
					value = DataTransferUtil.convertFieldValue(context, metaForm, metaGridCell.getCellType(),
							metaGridCell.getProperties(), dataTable, columnKey);
					value = CSVUtil.convertCSVValue(metaColumn, TypeConvertor.toString(value));
					exportValue += value + ",";

					if (row == 0) {
						exportHeader += CSVUtil.convertCSVValue(null, metaColumn.getCaption()) + ",";
					}

				}
			}

			if (row == 0) {
				osw.append(exportHeader + EndingSymbol);
			}
			osw.append(exportValue += EndingSymbol);
			exportValue = "";

			row++;
		}

		if (exportHeader.isEmpty()) {
			Iterator<MetaColumn> itMetaColumn = metaTable.iterator();
			while (itMetaColumn.hasNext()) {
				metaColumn = itMetaColumn.next();
				if (map.containsKey(metaColumn.getKey())) {
					exportHeader += CSVUtil.convertCSVValue(null, metaColumn.getCaption()) + ",";
				}
			}
			osw.append(exportHeader + EndingSymbol);
		}

		osw.append(exportValue += EndingSymbol + EndingSymbol);
	}

	@SuppressWarnings("deprecation")
	private void exportHeadTable(OutputStreamWriter osw, MetaForm metaForm, MetaTable metaTable, DataTable dataTable)
			throws Throwable {
		// 记录ColumnKey和MetaComponent的关系
		HashMap<String, MetaComponent> map = new HashMap<String, MetaComponent>();
		// 先找到属于这张表的字段
		MetaComponent metaComponent = null;
		Iterator<MetaComponent> itComponent = metaForm.getAllComponents().iterator();
		while (itComponent.hasNext()) {
			metaComponent = itComponent.next();
			if (metaTable.getKey().equals(metaComponent.getTableKey())) {
				map.put(metaComponent.getColumnKey(), metaComponent);
			}
		}

		Object value = "";
		String exportHeader = "";
		String exportValue = "";
		MetaColumn metaColumn = null;

		// 循环所有列，有字段的才做导出
		dataTable.next(true);
		Iterator<MetaColumn> itMetaColumn = metaTable.iterator();
		while (itMetaColumn.hasNext()) {
			metaColumn = itMetaColumn.next();
			String columnKey = metaColumn.getKey();
			metaComponent = map.get(columnKey);
			if (metaComponent != null) {
				value = DataTransferUtil.convertFieldValue(context, metaForm, metaComponent.getControlType(),
						metaComponent.getProperties(), dataTable, columnKey);
				value = CSVUtil.convertCSVValue(metaColumn, TypeConvertor.toString(value));
				exportValue += value + ",";
				exportHeader += CSVUtil.convertCSVValue(null, metaColumn.getCaption()) + ",";
			}
		}

		osw.append(exportHeader + EndingSymbol);
		osw.append(exportValue + EndingSymbol);
		osw.append(EndingSymbol + EndingSymbol);
	}

	private void processParameter(DefaultContext context, ArrayList<MetaTable> tableList) throws Throwable {
		for (MetaTable table : tableList) {
			MetaParameterCollection paraCollection = table.getParameterCollection();
			if (paraCollection != null) {
				TableFilterDetail tableFilter = filterMap.get(table.getKey());
				if (tableFilter == null) {
					tableFilter = new TableFilterDetail(table.getKey());
					filterMap.put(table.getKey(), tableFilter);
				}
				ArrayList<Object> list = new ArrayList<Object>();
				for (MetaParameter para : paraCollection) {
					if (para.getSourceType() == ParameterSourceType.CONST)
						list.add(ConstUtil.getValue(para.getValue(), para.getDataType()));
					else if (para.getSourceType() == ParameterSourceType.FORMULA) {
						Object value = context.getMidParser().eval(ScriptType.Formula, para.getFormula());
						int dataType = para.getDataType();
						if (dataType != -1)
							value = TypeConvertor.toDataType(para.getDataType(), value);
						list.add(value);
					} else
						list.add(null);
				}
				tableFilter.setParaValues(list);
			}
		}
	}
}