/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.excel.template;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.excel.template.ExcelCell;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelCell;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelRow;
import com.bokesoft.yigo.parser.IEval;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;

public class ExcelRow {
    private int height = 0;
    private int type = -1;
    private int rowIndex = -1;
    private String groupDefination = "";
    private int groupLevel = 0;
    private String groupPosition = "";
    private int groupHeadRowCount = 0;
    private int groupTailRowCount = 0;
    private String tableKey = "";
    private ArrayList<ExcelCell> excelCells = null;
    private LinkedHashMap<Integer, ExcelCell> excelCellMap = null;
    private IEval parser = null;

    public ExcelRow(MetaExcelRow object3, IEval object2, boolean bl) {
        this.rowIndex = object3.getRowIndex();
        this.type = object3.getType();
        this.height = object3.getHeight();
        this.tableKey = object3.getTableKey();
        this.groupLevel = object3.getGroupLevel();
        this.groupPosition = object3.getGroupPosition();
        this.groupHeadRowCount = object3.getGroupHeadRowCount();
        this.groupTailRowCount = object3.getGroupTailRowCount();
        this.groupDefination = object3.getGroupDefination();
        this.parser = object2;
        this.excelCells = new ArrayList();
        this.excelCellMap = new LinkedHashMap();
        for (Object object3 : object3) {
            object3 = new ExcelCell((MetaExcelCell)object3, this.rowIndex);
            this.addCell((ExcelCell)object3);
        }
        this.resetExportCells(bl);
    }

    public int getHeight() {
        return this.height;
    }

    public int getType() {
        return this.type;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public String getTableKey() {
        return this.tableKey;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public void setType(int n) {
        this.type = n;
    }

    public void setRowIndex(int n) {
        this.rowIndex = n;
    }

    public void setTableKey(String string) {
        this.tableKey = string;
    }

    public void setGroupLevel(int n) {
        this.groupLevel = n;
    }

    public int getGroupLevel() {
        return this.groupLevel;
    }

    public void setGroupPosition(String string) {
        this.groupPosition = string;
    }

    public String getGroupPosition() {
        return this.groupPosition;
    }

    public void setGroupHeadRowCount(int n) {
        this.groupHeadRowCount = n;
    }

    public int getGroupHeadRowCount() {
        return this.groupHeadRowCount;
    }

    public void setGroupTailRowCount(int n) {
        this.groupTailRowCount = n;
    }

    public int getGroupTailRowCount() {
        return this.groupTailRowCount;
    }

    public void setGroupDefination(String string) {
        this.groupDefination = string;
    }

    public String getGroupDefination() {
        return this.groupDefination;
    }

    public boolean hasExpandColumn() {
        Iterator<ExcelCell> iterator = this.excelCells.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().isColumnExpand()) continue;
            return true;
        }
        return false;
    }

    public int getCellCount() {
        return this.excelCells.size();
    }

    public ExcelCell getCell(int n) {
        return this.excelCells.get(n);
    }

    public ExcelCell getCellByIndexInExcel(int n) {
        return this.excelCellMap.get(n);
    }

    public void replace(int n, int n2, LinkedList<ExcelCell> linkedList, int n3) {
        Iterator<ExcelCell> iterator = new ArrayList<ExcelCell>();
        int n4 = this.excelCells.indexOf(this.getCellByIndexInExcel(n));
        int n5 = -1;
        for (int i = 0; i < n2; ++i) {
            ExcelCell excelCell = this.getCellByIndexInExcel(n + i);
            if (excelCell == null) continue;
            ((ArrayList)((Object)iterator)).add(excelCell);
            n5 = n + i;
        }
        Iterator iterator2 = ((ArrayList)((Object)iterator)).iterator();
        while (iterator2.hasNext()) {
            iterator = (ExcelCell)iterator2.next();
            this.excelCells.remove(iterator);
        }
        int n6 = n3 - n2;
        for (ExcelCell excelCell : this.excelCells) {
            n3 = excelCell.getCellIndex();
            if (n3 <= n5) continue;
            excelCell.setCellIndex(n3 + n6);
        }
        for (ExcelCell excelCell : linkedList) {
            if (excelCell != null && excelCell.need) {
                excelCell.setCellIndex(n);
                this.excelCells.add(n4, excelCell);
                ++n4;
            }
            ++n;
        }
        this.excelCellMap.clear();
        for (ExcelCell excelCell : this.excelCells) {
            this.excelCellMap.put(excelCell.getCellIndex(), excelCell);
        }
    }

    public Iterator<ExcelCell> iterator() {
        return this.excelCells.iterator();
    }

    private void addCell(ExcelCell excelCell) {
        this.excelCells.add(excelCell);
        this.excelCellMap.put(excelCell.getCellIndex(), excelCell);
    }

    public void resetExportCells(boolean bl) {
        boolean bl2 = true;
        if (this.type == -1 || this.type == 1 || this.type == 5) {
            bl2 = false;
        }
        int n = 1;
        if (this.excelCells.size() > 0) {
            n = this.excelCells.get(0).getCellIndex();
        }
        this.excelCellMap.clear();
        for (ExcelCell object : this.excelCells) {
            int n2;
            int n3 = n2 = bl2 && bl ? n : object.getCellIndex();
            if (this.isIgnoreExportCell(object)) continue;
            object.setCellIndex(n2);
            this.excelCellMap.put(n2, object);
            n += object.getMergedColumnSpan();
        }
        this.excelCells.clear();
        for (Map.Entry entry : this.excelCellMap.entrySet()) {
            this.excelCells.add((ExcelCell)entry.getValue());
        }
    }

    private boolean isIgnoreExportCell(ExcelCell excelCell) {
        boolean bl = false;
        if (this.parser == null) {
            return false;
        }
        try {
            bl = StringUtil.isBlankOrNull((String)excelCell.getIgnoreExport()) ? false : TypeConvertor.toBoolean((Object)this.parser.eval(0, excelCell.getIgnoreExport()));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return bl;
    }
}

