/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.excel.template;

import com.bokesoft.yes.excel.template.ColumnExpandItem;
import com.bokesoft.yes.excel.template.ExcelCell;
import com.bokesoft.yes.excel.template.ExcelSheet;
import com.bokesoft.yes.excel.template.IExcelCellProcess;
import com.bokesoft.yes.excel.template.IExcelColumnCellObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ExcelColumnExpandCellGroup
implements IExcelColumnCellObject {
    private ExcelCell cell = null;
    private int rowIndex = -1;
    private boolean isLeaf = false;
    private ArrayList<IExcelColumnCellObject> objectArray = new ArrayList();
    private int count = 0;

    @Override
    public void setCell(ExcelCell excelCell) {
        this.cell = excelCell;
    }

    public ExcelCell getCell() {
        return this.cell;
    }

    public void setRowIndex(int n) {
        this.rowIndex = n;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public void setLeaf(boolean bl) {
        this.isLeaf = bl;
    }

    public void add(IExcelColumnCellObject iExcelColumnCellObject) {
        this.objectArray.add(iExcelColumnCellObject);
    }

    public Iterator<IExcelColumnCellObject> iterator() {
        return this.objectArray.iterator();
    }

    @Override
    public int getObjectType() {
        return 1;
    }

    public void clear() {
        this.objectArray.clear();
    }

    public void addAll(List<IExcelColumnCellObject> list) {
        this.objectArray.addAll(list);
    }

    @Override
    public IExcelColumnCellObject clone() {
        ExcelColumnExpandCellGroup excelColumnExpandCellGroup = new ExcelColumnExpandCellGroup();
        excelColumnExpandCellGroup.setCell(this.cell);
        excelColumnExpandCellGroup.setLeaf(this.isLeaf);
        excelColumnExpandCellGroup.setRowIndex(this.rowIndex);
        excelColumnExpandCellGroup.setCount(this.count);
        for (IExcelColumnCellObject iExcelColumnCellObject : this.objectArray) {
            excelColumnExpandCellGroup.add(iExcelColumnCellObject.clone());
        }
        return excelColumnExpandCellGroup;
    }

    @Override
    public void traversalCell(ColumnExpandItem columnExpandItem, IExcelCellProcess iExcelCellProcess) {
        Iterator<IExcelColumnCellObject> iterator = this.objectArray.iterator();
        while (iterator.hasNext()) {
            iterator.next().traversalCell(columnExpandItem, iExcelCellProcess);
        }
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int n) {
        this.count = n;
    }

    public void calcCount() {
        this.count = 0;
        for (IExcelColumnCellObject iExcelColumnCellObject : this.objectArray) {
            if (iExcelColumnCellObject.getObjectType() == 1) {
                iExcelColumnCellObject = (ExcelColumnExpandCellGroup)iExcelColumnCellObject;
                ((ExcelColumnExpandCellGroup)iExcelColumnCellObject).calcCount();
                this.count += ((ExcelColumnExpandCellGroup)iExcelColumnCellObject).getCount();
                continue;
            }
            ++this.count;
        }
    }

    public int getChildrenCount() {
        int n = 0;
        for (IExcelColumnCellObject iExcelColumnCellObject : this.objectArray) {
            if (iExcelColumnCellObject.getObjectType() == 1) {
                iExcelColumnCellObject = (ExcelColumnExpandCellGroup)iExcelColumnCellObject;
                n += ((ExcelColumnExpandCellGroup)iExcelColumnCellObject).getChildrenCount();
                continue;
            }
            ++n;
        }
        return n;
    }

    @Override
    public void getLeafCells(LinkedList<ExcelCell> linkedList, int n) {
        Iterator<IExcelColumnCellObject> iterator = this.objectArray.iterator();
        while (iterator.hasNext()) {
            iterator.next().getLeafCells(linkedList, n);
        }
    }

    @Override
    public void processMerge(ExcelSheet excelSheet) {
        Object object;
        int n = this.cell.getRowIndex();
        Iterator<IExcelColumnCellObject> iterator = this.objectArray.iterator();
        LinkedList<ExcelCell> linkedList = new LinkedList<ExcelCell>();
        int n2 = this.cell.getCellIndex();
        while (iterator.hasNext()) {
            IExcelColumnCellObject iExcelColumnCellObject = iterator.next();
            object = new LinkedList();
            iExcelColumnCellObject.getLeafCells((LinkedList<ExcelCell>)object, n);
            int n3 = ((LinkedList)object).size();
            for (int i = 0; i < n3; ++i) {
                ExcelCell excelCell = (ExcelCell)((LinkedList)object).get(i);
                if (i == 0) {
                    if (excelCell != null) {
                        excelCell.setCellIndex(n2);
                        excelCell.setMergedColumnSpan(n3);
                        linkedList.add(excelCell);
                        excelCell.need = true;
                        continue;
                    }
                    ExcelCell excelCell2 = (ExcelCell)linkedList.getLast();
                    excelCell2.setMergedColumnSpan(excelCell2.getMergedColumnSpan() + 1);
                    continue;
                }
                if (excelCell == null) continue;
                excelCell.need = false;
            }
        }
        object = this.objectArray.iterator();
        while (object.hasNext()) {
            ((IExcelColumnCellObject)object.next()).processMerge(excelSheet);
        }
    }
}

