/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.excel.cmd.stamp.expand;

import com.bokesoft.yes.excel.cmd.stamp.expand.TemplateDimensionsCreator;
import com.bokesoft.yes.excel.cmd.stamp.expand.work.ExcelTableDetailExpandWork;
import com.bokesoft.yes.excel.cmd.stamp.expand.work.ExcelTableHeadExpandWork;
import com.bokesoft.yes.excel.template.ExcelTemplate;
import com.bokesoft.yes.excel.template.ExcelTemplateField;
import com.bokesoft.yes.excel.template.ExcelTemplateSheet;
import com.bokesoft.yes.excel.template.ExcelTemplateTable;
import com.bokesoft.yes.excel.template.style.StampExcelStyleFactory;
import com.bokesoft.yes.tools.dic.proxy.IDictCacheProxy;
import com.bokesoft.yigo.mid.base.BaseContext;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.parser.IEval;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.struct.expand.AbstractExpandMaster;
import com.bokesoft.yigo.struct.expand.IExpandTableDefine;
import com.bokesoft.yigo.struct.expand.IExpandWork;
import com.bokesoft.yigo.struct.expand.work.DataTableExpandWork;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.ss.usermodel.Workbook;

public class ExcelExpandMaster
extends AbstractExpandMaster<ExcelTemplateField, ExcelTemplateField> {
    private DefaultContext context = null;
    private Document document = null;
    private Workbook workbook;
    private StampExcelStyleFactory styleFactory;

    public ExcelExpandMaster(Document document, Workbook workbook, StampExcelStyleFactory stampExcelStyleFactory, DefaultContext defaultContext) {
        this.document = document;
        this.workbook = workbook;
        this.styleFactory = stampExcelStyleFactory;
        this.context = defaultContext;
    }

    public void doExpand(ExcelTemplate object) throws Throwable {
        IEval iEval = this.context.getMidParser();
        IDictCacheProxy iDictCacheProxy = this.context.getDictCache();
        Iterator iterator = object.getTemplateSheets().iterator();
        while (iterator.hasNext()) {
            for (Object object2 : ((ExcelTemplateSheet)iterator.next()).getTemplateTables()) {
                if (!object2.hasExpandField()) continue;
                DataTable dataTable = this.document.get(object2.getTableKey());
                object = new TemplateDimensionsCreator(dataTable, (IEval<BaseContext>)iEval, iDictCacheProxy).createDimensions((IExpandTableDefine)object2);
                Object object3 = new ExcelTableDetailExpandWork((ExcelTemplateTable)object2);
                this.addExpandWork((IExpandWork)object3);
                object3 = new ExcelTableHeadExpandWork(this.workbook, (ExcelTemplateTable)object2, this.styleFactory);
                this.addExpandWork((IExpandWork)object3);
                dataTable = new DataTableExpandWork(dataTable, this.document);
                this.addExpandWork((IExpandWork)dataTable);
                object2 = object2.getFixedFieldKeys();
                this.doWorks((List)object2, (List)object, null);
                this.clearWorks();
            }
        }
    }
}

