/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.excel.cmd.stamp.base;

import com.bokesoft.yes.common.storage.IStorageService;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.excel.cmd.stamp.input.reader.picture.builder.AbstractPictureSheetBuilder;
import com.bokesoft.yes.excel.cmd.stamp.input.reader.picture.storage.DefaultStorageService;
import com.bokesoft.yes.excel.template.ExcelTemplateField;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.document.Document;
import java.util.HashMap;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class ExcelProcessContext {
    private DefaultContext context = null;
    private String formKey = null;
    private MetaDataObject metaDataObject = null;
    private ScriptEngine engine = null;
    private StringBuilder sbCheckResult = null;
    private ExcelTemplateField curTemplateField = null;
    private AbstractPictureSheetBuilder pictureSheetBuilder = null;
    private Document curDocument = null;
    private DefaultStorageService defaultStorageService = new DefaultStorageService();
    private HashMap<String, IStorageService> mapUserDefineStoreServices = new HashMap();

    public ExcelProcessContext(String object, MetaDataObject metaDataObject, DefaultContext defaultContext) {
        this.context = defaultContext;
        this.formKey = object;
        this.metaDataObject = metaDataObject;
        this.sbCheckResult = new StringBuilder("");
        object = new ScriptEngineManager();
        this.engine = ((ScriptEngineManager)object).getEngineByName("JavaScript");
    }

    public DefaultContext getContext() {
        return this.context;
    }

    public String getFormKey() {
        return this.formKey;
    }

    public MetaDataObject getMetaDataObject() {
        return this.metaDataObject;
    }

    public boolean check(String string) {
        if (StringUtil.isBlankOrNull((String)string)) {
            return true;
        }
        if (this.engine != null) {
            try {
                return TypeConvertor.toBoolean((Object)this.engine.eval(string));
            }
            catch (ScriptException scriptException) {
                scriptException.printStackTrace();
            }
        }
        return true;
    }

    public void recordError(StringBuilder stringBuilder) {
        this.sbCheckResult.append((CharSequence)stringBuilder).append("\r\n");
    }

    public String getError() {
        return this.sbCheckResult.toString();
    }

    public boolean hasError() {
        return this.sbCheckResult.length() > 0;
    }

    public void setPictureSheetBuilder(AbstractPictureSheetBuilder abstractPictureSheetBuilder) {
        this.pictureSheetBuilder = abstractPictureSheetBuilder;
    }

    public AbstractPictureSheetBuilder getPictureSheetBuilder() {
        return this.pictureSheetBuilder;
    }

    public void setCurTemplateField(ExcelTemplateField excelTemplateField) {
        this.curTemplateField = excelTemplateField;
    }

    public ExcelTemplateField getCurTemplateField() {
        return this.curTemplateField;
    }

    public void setCurDocument(Document document) {
        this.curDocument = document;
    }

    public Document getCurDocument() {
        return this.curDocument;
    }

    public IStorageService getStorage(String string) throws Throwable {
        if (StringUtil.isBlankOrNull((String)string)) {
            return this.defaultStorageService;
        }
        if (this.mapUserDefineStoreServices.containsKey(string)) {
            this.mapUserDefineStoreServices.get(string);
        } else {
            try {
                IStorageService iStorageService = (IStorageService)Class.forName(string).newInstance();
                this.mapUserDefineStoreServices.put(string, iStorageService);
                return iStorageService;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        throw new Throwable("unknow class name:".concat(String.valueOf(string)));
    }
}

