/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.excel.cmd.stamp;

import com.bokesoft.yes.data.service.DocumentServiceManager;
import com.bokesoft.yes.data.service.IDocumentService;
import com.bokesoft.yes.excel.cmd.normal.IExport;
import com.bokesoft.yes.excel.cmd.stamp.expand.ExcelExpandMaster;
import com.bokesoft.yes.excel.cmd.stamp.exportor.DocumentExportor4Stamp;
import com.bokesoft.yes.excel.cmd.stamp.exportor.DocumentExportor4XmlTemplate;
import com.bokesoft.yes.excel.cmd.stamp.exportor.IDocumentExportor;
import com.bokesoft.yes.excel.cmd.stamp.output.strategy.BatchOutputStrategy;
import com.bokesoft.yes.excel.cmd.stamp.output.strategy.IOutputStrategy;
import com.bokesoft.yes.excel.cmd.stamp.output.strategy.MultiBatchOutputStrategy;
import com.bokesoft.yes.excel.cmd.stamp.output.strategy.SingleOutputStrategy;
import com.bokesoft.yes.excel.template.ExcelTemplate;
import com.bokesoft.yes.excel.template.style.StampExcelStyleFactory;
import com.bokesoft.yes.excel.template.util.ExcelTemplateUtils;
import com.bokesoft.yes.excel.transformer.ExcelTransformerFactory;
import com.bokesoft.yes.excel.utils.ExcelFileUtil;
import com.bokesoft.yes.struct.filedata.FileData;
import com.bokesoft.yigo.common.def.EExcelTemplateType;
import com.bokesoft.yigo.common.ui.AbstractRuntimeUIConfig;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelWorkbook;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.util.ExcelUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.poi.ss.usermodel.Workbook;

public class ExportExcelWithStamp
implements IExport {
    private DefaultContext context = null;
    private String postExportServiceName = null;
    private String exportFileName = null;
    private Document baseDocument = null;
    private String templateKey = null;
    private String curUIFormKey = null;
    private AbstractRuntimeUIConfig runtimeUIConfig;
    private MetaForm metaForm4Export = null;
    private EExcelTemplateType templateType = EExcelTemplateType.Single;
    private boolean needDownload = false;

    public ExportExcelWithStamp(DefaultContext defaultContext, String string, EExcelTemplateType eExcelTemplateType, String string2, Document document, AbstractRuntimeUIConfig abstractRuntimeUIConfig, String string3, String string4, boolean bl) throws Throwable {
        this.context = defaultContext;
        this.templateKey = string;
        this.templateType = eExcelTemplateType;
        this.curUIFormKey = string2;
        this.postExportServiceName = string3;
        this.baseDocument = document;
        this.runtimeUIConfig = abstractRuntimeUIConfig;
        this.exportFileName = string4;
        this.needDownload = bl;
    }

    @Override
    public FileData exportData() throws Throwable {
        Workbook workbook = this.exportToWorkbook();
        Object object = ExcelUtils.getExportFilePath(this.context.getVE().getMetaFactory(), this.metaForm4Export.getKey());
        new FileData();
        if (!this.needDownload) {
            workbook = ExcelFileUtil.writeExcel(workbook, (String)object);
        } else {
            workbook = ExcelFileUtil.convertWorkbookToFileData(this.metaForm4Export.getKey(), this.exportFileName, workbook);
            workbook.setPath((String)object);
        }
        object = ExcelUtils.getPostExtProcess(this.context, this.postExportServiceName);
        if (object != null) {
            object.process(this.context, (FileData)workbook);
        }
        if (this.needDownload) {
            return workbook;
        }
        return new FileData();
    }

    public byte[] exportToBytes() throws Throwable {
        Workbook workbook = this.exportToWorkbook();
        return this.parseWorkbookToBytes(workbook);
    }

    private Workbook exportToWorkbook() throws Throwable {
        IMetaFactory iMetaFactory = this.context.getVE().getMetaFactory();
        MetaForm metaForm = iMetaFactory.getMetaForm(this.curUIFormKey);
        if (EExcelTemplateType.SingleBatch_V0 == this.templateType || EExcelTemplateType.Single_V0 == this.templateType) {
            iMetaFactory = ExcelTemplateUtils.getMetaExcelWorkbook((String)this.templateKey, (EExcelTemplateType)this.templateType, (MetaForm)metaForm, (AbstractRuntimeUIConfig)this.runtimeUIConfig, (IMetaFactory)iMetaFactory);
            this.metaForm4Export = this.context.getVE().getMetaFactory().getMetaForm(iMetaFactory.getFormKey());
            iMetaFactory = this.export4V0((MetaExcelWorkbook)iMetaFactory);
        } else {
            iMetaFactory = ExcelTemplateUtils.getExcelTemplate((String)this.templateKey, (EExcelTemplateType)this.templateType, (MetaForm)metaForm, (AbstractRuntimeUIConfig)this.runtimeUIConfig, (IMetaFactory)iMetaFactory);
            this.metaForm4Export = this.context.getVE().getMetaFactory().getMetaForm(iMetaFactory.getFormKey());
            iMetaFactory = this.export4Stamp((ExcelTemplate)iMetaFactory, this.metaForm4Export.getProjectKey());
        }
        iMetaFactory.setForceFormulaRecalculation(true);
        return iMetaFactory;
    }

    private Workbook export4V0(MetaExcelWorkbook metaExcelWorkbook) throws Throwable {
        DocumentExportor4XmlTemplate documentExportor4XmlTemplate = new DocumentExportor4XmlTemplate(metaExcelWorkbook, this.context);
        switch (this.templateType) {
            case SingleBatch_V0: {
                ExportExcelWithStamp exportExcelWithStamp = this;
                exportExcelWithStamp.batchExportByMultiDocument(exportExcelWithStamp.templateKey, metaExcelWorkbook.getFormKey(), documentExportor4XmlTemplate, false);
                break;
            }
            case Single_V0: {
                documentExportor4XmlTemplate.export(this.baseDocument, "");
            }
        }
        return documentExportor4XmlTemplate.getWorkbook();
    }

    private Workbook export4Stamp(ExcelTemplate excelTemplate, String string) throws Throwable {
        string = ExcelTemplateUtils.createTemplateExcelWorkbook((ExcelTemplate)excelTemplate, (String)string, (IMetaFactory)this.context.getVE().getMetaFactory());
        ExcelTransformerFactory excelTransformerFactory = new ExcelTransformerFactory();
        Object object = new StampExcelStyleFactory((Workbook)string, excelTemplate.isExcelFormatTemplate());
        switch (excelTemplate.getType()) {
            case Batch: {
                object = excelTemplate.getSheetCount() > 1 ? new MultiBatchOutputStrategy((Workbook)string, (StampExcelStyleFactory)object, excelTemplate) : new BatchOutputStrategy((Workbook)string, (StampExcelStyleFactory)object, excelTemplate);
                object = new DocumentExportor4Stamp((IOutputStrategy)object, excelTemplate, excelTransformerFactory, this.context);
                this.batchExport4Stamp((Workbook)string, excelTemplate.getKey(), excelTemplate.getFormKey(), (IDocumentExportor)object);
                break;
            }
            case Single: {
                if (excelTemplate.hasExpandField()) {
                    new ExcelExpandMaster(this.baseDocument, (Workbook)string, (StampExcelStyleFactory)object, this.context).doExpand(excelTemplate);
                }
                object = new SingleOutputStrategy((Workbook)string, (StampExcelStyleFactory)object, excelTemplate);
                new DocumentExportor4Stamp((IOutputStrategy)object, excelTemplate, excelTransformerFactory, this.context).export(this.baseDocument, "");
                break;
            }
            case MultiBatch: {
                object = new MultiBatchOutputStrategy((Workbook)string, (StampExcelStyleFactory)object, excelTemplate);
                object = new DocumentExportor4Stamp((IOutputStrategy)object, excelTemplate, excelTransformerFactory, this.context);
                this.batchExport4Stamp((Workbook)string, excelTemplate.getKey(), excelTemplate.getFormKey(), (IDocumentExportor)object);
                break;
            }
            default: {
                throw new Throwable("unsupport exprort excel template type!");
            }
        }
        return string;
    }

    private void batchExport4Stamp(Workbook workbook, String string, String string2, IDocumentExportor iDocumentExportor) throws Throwable {
        if (this.baseDocument.getMetaDataObject() != null && this.baseDocument.getMetaDataObject().getMainTable() != null && this.baseDocument.getMetaDataObject().getMainTable().getSourceType() == 0) {
            iDocumentExportor.export(this.baseDocument, "");
            return;
        }
        this.batchExportByMultiDocument(string, string2, iDocumentExportor, true);
    }

    private void batchExportByMultiDocument(String string, String string2, IDocumentExportor iDocumentExportor, boolean bl) throws Throwable {
        List<Long> list = ExcelUtils.getOIDsFromDocument(this.baseDocument);
        IDocumentService iDocumentService = DocumentServiceManager.getInstance().getDocumentService(this.context, "Excel", "ExportExcelWithStamp", string2, string);
        this.context.setDocument(this.baseDocument);
        iDocumentService.init(this.context, string2, list, bl);
        while (iDocumentService.hasNext()) {
            string = (Document)iDocumentService.next();
            if (string == null) continue;
            this.context.setDocument((Document)string);
            iDocumentExportor.export((Document)string, iDocumentService.getDocumentTitle((Document)string));
        }
        this.context.setDocument(this.baseDocument);
    }

    private byte[] parseWorkbookToBytes(Workbook workbook) throws IOException {
        byte[] byArray;
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            workbook.write((OutputStream)byteArrayOutputStream);
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (Throwable throwable) {
            if (byteArrayOutputStream != null) {
                byteArrayOutputStream.close();
            }
            if (workbook != null) {
                workbook.close();
            }
            throw throwable;
        }
        byteArrayOutputStream.close();
        if (workbook != null) {
            workbook.close();
        }
        return byArray;
    }
}

