/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.excel.cmd.normal;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.excel.template.util.ExcelUtil;
import com.bokesoft.yes.excel.utils.ExcelFileUtil;
import com.bokesoft.yes.mid.cmd.DefaultServiceCmd;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yes.report.output.OutputCell;
import com.bokesoft.yes.report.output.OutputColumn;
import com.bokesoft.yes.report.output.OutputRow;
import com.bokesoft.yes.report.output.OutputSection;
import com.bokesoft.yes.struct.filedata.FileData;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.util.ExcelUtils;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.json.JSONObject;

public class ExportGridCmd
extends DefaultServiceCmd {
    private String formKey = null;
    private String exportFileName = null;
    private String postExportServiceName = null;
    private boolean needDownload = false;
    private OutputSection gridSection = null;

    public void dealArguments(DefaultContext object, StringHashMap<Object> stringHashMap) throws Throwable {
        this.formKey = TypeConvertor.toString((Object)stringHashMap.get((Object)"formKey"));
        this.needDownload = TypeConvertor.toBoolean((Object)stringHashMap.get((Object)"needDownload"));
        this.exportFileName = TypeConvertor.toString((Object)stringHashMap.get((Object)"exportFileName"));
        this.postExportServiceName = TypeConvertor.toString((Object)stringHashMap.get((Object)"postExportServiceName"));
        this.gridSection = new OutputSection();
        object = TypeConvertor.toString((Object)stringHashMap.get((Object)"section"));
        object = new JSONObject((String)object);
        this.gridSection.fromJSON((JSONObject)object);
    }

    public Object doCmd(DefaultContext defaultContext) throws Throwable {
        int n;
        Object object = new XSSFWorkbook();
        Sheet sheet = ExcelUtil.getSheet((Workbook)object, (String)"Sheet1");
        int n2 = this.gridSection.getRowCount();
        int n3 = this.gridSection.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            OutputRow outputRow = this.gridSection.getRow(i);
            for (n = 0; n < n3; ++n) {
                OutputCell outputCell = outputRow.get(n);
                ExcelUtil.setCellValue((Sheet)sheet, (int)i, (int)n, (Object)outputCell.getText());
            }
        }
        for (n = 0; n < n3; ++n) {
            OutputColumn outputColumn = this.gridSection.getColumn(n);
            if (outputColumn == null) continue;
            int n4 = (outputColumn.getWidth() << 8) / 7 + 500;
            sheet.setColumnWidth(n, n4);
        }
        new FileData();
        String string = ExcelUtils.getExportFilePath(defaultContext.getVE().getMetaFactory(), this.formKey);
        FileData fileData = !this.needDownload ? ExcelFileUtil.writeExcel((Workbook)object, string) : ExcelFileUtil.convertWorkbookToFileData(this.formKey, this.exportFileName, (Workbook)object);
        object = ExcelUtils.getPostExtProcess(defaultContext, this.postExportServiceName);
        if (object != null) {
            object.process(defaultContext, fileData);
        }
        if (this.needDownload) {
            return fileData;
        }
        return new FileData();
    }

    public IServiceCmd<DefaultContext> newInstance() {
        return new ExportGridCmd();
    }

    public String getCmd() {
        return "ExportGrid";
    }

    public boolean getNeedServiceRight() {
        return true;
    }
}

