package com.bokesoft.yes.excel.template;

import com.bokesoft.yigo.common.def.HAlignment;
import com.bokesoft.yigo.common.def.VAlignment;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelDisplay;

public class ExcelDisplay {
	/** 字体 */
	private ExcelFont font = null;
	/** 格式 */
	private ExcelFormat format = null;
	/** 边框 */
	private ExcelBorder border = null;
	/** 水平对齐方式 */
	private int hAlign = HAlignment.CENTER;
	/** 垂直对齐方式 */
	private int vAlign = VAlignment.CENTER;
	/** 背景色 */
	private String backColor = "";
	/** 前景色 */
	private String foreColor = "";
	/** 是否换行*/
	private boolean wrapText = false;
	
	private ExcelDisplay(){};
	
	public ExcelDisplay(MetaExcelDisplay display) {
		this.hAlign = display.getHAlign();
		this.vAlign = display.getVAlign();
		this.backColor = display.getBackColor();
		this.foreColor = display.getForeColor();
		this.wrapText =display.isWrapText();
		
		if (display.getFont() != null) {
			this.font = new ExcelFont(display.getFont());
		}
		
		if (display.getFormat() != null) {
			this.format = new ExcelFormat(display.getFormat());
		}
		
		if (display.getBorder() != null) {
			this.border = new ExcelBorder(display.getBorder());
		}
	}
	
	/**
	 * 设置字体
	 * 
	 * @param font
	 *            字体
	 */
	public void setFont(ExcelFont font) {
		this.font = font;
	}

	/**
	 * 取得字体
	 * 
	 * @return 字体
	 */
	public ExcelFont getFont() {
		return this.font;
	}

	/**
	 * 设置格式
	 * 
	 * @param format
	 *            格式
	 */
	public void setFormat(ExcelFormat format) {
		this.format = format;
	}

	/**
	 * 取得格式
	 * 
	 * @return 格式
	 */
	public ExcelFormat getFormat() {
		return this.format;
	}

	/**
	 * 获取边框信息
	 * 
	 * @return
	 */
	public ExcelBorder getBorder() {
		return border;
	}

	public void setBorder(ExcelBorder border) {
		this.border = border;
	}

	public int getHAlign() {
		return hAlign;
	}

	public int getVAlign() {
		return vAlign;
	}

	public String getBackColor() {
		return backColor;
	}

	public String getForeColor() {
		return foreColor;
	}

	public void setHAlign(int hAlign) {
		this.hAlign = hAlign;
	}

	public void setVAlign(int vAlign) {
		this.vAlign = vAlign;
	}

	public void setBackColor(String backColor) {
		this.backColor = backColor;
	}

	public void setForeColor(String foreColor) {
		this.foreColor = foreColor;
	}

	public boolean isWrapText() {
		return wrapText;
	}

	public void setWrapText(boolean wrapText) {
		this.wrapText = wrapText;
	}

	public ExcelDisplay clone() {
		ExcelDisplay newObject = new ExcelDisplay();
		newObject.setHAlign(hAlign);
		newObject.setVAlign(vAlign);
		newObject.setBackColor(backColor);
		newObject.setForeColor(foreColor);
		
		newObject.setFont(font == null ? null : font.clone());
		newObject.setFormat(format == null ? null : format.clone());
		newObject.setBorder(border == null ? null : border.clone());
		return newObject;
	}
	
	public String createStyleKey() {
		String key = (font == null ? "NullFont" : font.createStyleKey()) + "#"
				+ (border == null ? "NullBorder" : border.createStyleKey()) + "#" + hAlign + "#" + vAlign + "#"
				+ backColor + "#" + foreColor + "#" + wrapText
				+ (format == null ? "NullFormat" : format.getFieldKeys() + "#" + format.getFormatString() + "#" + format.getItemKey());
		return key;
	}
}
