package com.bokesoft.yes.excel.document;

import java.util.ArrayList;
import java.util.TreeMap;

/**
 * 记录Excel模板中的表格信息 以便计算
 */
public class ExcelGridInfo {
	/**记录表格的开始行*/
	private int beginRowIndex = -1;
	/** 记录表格的结束行*/
	private int endRowIndex = -1;
	/** 记录表格对应的数据源表key*/
	private String tableKey = null;
	/** 表格是否有扩展*/
	private boolean isColumnExpand = false;
	/** 表格是否有分组汇总*/
	private boolean hasGroup = false;
	/** 记录分组字段的列表*/
	ArrayList<String> groupFieldList = new ArrayList<String>();
	/** 记录分组级别和分组单元格分组信息的Map*/
	TreeMap<Integer, GroupInfo> groupLevelMap = new TreeMap<Integer, GroupInfo>();

	public ExcelGridInfo(String tableKey, int beginRowIndex, int endRowIndex) {
		this.tableKey = tableKey;
		this.beginRowIndex = beginRowIndex;
		this.endRowIndex = endRowIndex;
	}

	public int getBeginRowIndex() {
		return beginRowIndex;
	}

	public int getEndRowIndex() {
		return endRowIndex;
	}

	public String getTableKey() {
		return tableKey;
	}

	public boolean isColumnExpand() {
		return isColumnExpand;
	}

	public boolean isHasSum() {
		return hasGroup;
	}

	public void setBeginRowIndex(int beginRowIndex) {
		this.beginRowIndex = beginRowIndex;
	}

	public void setEndRowIndex(int endRowIndex) {
		this.endRowIndex = endRowIndex;
	}

	public void setTableKey(String tableKey) {
		this.tableKey = tableKey;
	}

	public void setColumnExpand(boolean isColumnExpand) {
		this.isColumnExpand = isColumnExpand;
	}

	public void setHasGroup(boolean hasGroup) {
		this.hasGroup = hasGroup;
	}
	
	public void setGroupFieldList(ArrayList<String> groupFieldList) {
		this.groupFieldList = groupFieldList;
	}
	
	public ArrayList<String> getGroupFieldList(){
		return groupFieldList;
	}
	
	public void setGroupLevelMap(TreeMap<Integer, GroupInfo> groupLevelMap) {
		this.groupLevelMap = groupLevelMap;
	}
	
	public TreeMap<Integer, GroupInfo> getGroupLevelMap(){
		return groupLevelMap;
	}
}
