package com.bokesoft.yes.excel.cmd.stamp.input.strategy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.excel.cmd.stamp.base.ExcelProcessContext;
import com.bokesoft.yes.excel.cmd.stamp.input.doc.in.IInDocument;
import com.bokesoft.yes.excel.cmd.stamp.input.doc.in.IInTable;
import com.bokesoft.yes.excel.cmd.stamp.input.doc.in.InDocument;
import com.bokesoft.yes.excel.cmd.stamp.input.doc.in.InTable4MultiBatch;
import com.bokesoft.yes.excel.cmd.stamp.input.reader.IInputReader;
import com.bokesoft.yes.excel.cmd.stamp.input.reader.IInputReaderBag;
import com.bokesoft.yes.excel.template.ExcelTemplate;
import com.bokesoft.yes.excel.template.ExcelTemplateField;
import com.bokesoft.yes.excel.template.ExcelTemplateTable;
import com.bokesoft.yes.excel.template.constants.ExcelTemplateConstants;

/**
 * 数据分布在多个sheet, 通过关联字段建立数据关系
 * 
 * @author chenbb
 *
 */
public class MultiBatchInputStrategy implements IInputStrategy {

	private ExcelTemplate excelTemplate = null;

	private IInputReaderBag workbookReader = null;
	
	private ExcelProcessContext excelProcessContext = null;
	
	private LinkedHashMap<Object, IInDocument<IInTable>> mapInDoc = null;
	
	private Collection<IInDocument<IInTable>> docCollection = null;
	
	public MultiBatchInputStrategy(ExcelTemplate excelTemplate, IInputReaderBag workbookReader, ExcelProcessContext excelProcessContext) {
		this.excelTemplate = excelTemplate;
		this.workbookReader = workbookReader;
		this.excelProcessContext = excelProcessContext;
		this.mapInDoc = new LinkedHashMap<>();
		this.init();
	}
	
	private void init() {
		ExcelTemplateField templateField = excelTemplate.getDetailLinkedField();
		int startRowIndex = templateField.getRowIndex() + ExcelTemplateConstants.ROW_STEP_NEXT;
		int linkedFieldColIndex = templateField.getColIndex();
		String sheetName = templateField.getSheetName();
		int maxRowNum = workbookReader.getLastRowNum(sheetName);
		List<Object> listPrimaryValues = new ArrayList<>();
		for (int row = startRowIndex; row <= maxRowNum; row ++ ) {
			Object primaryValue = workbookReader.getValue(sheetName, row, linkedFieldColIndex, excelProcessContext);
			if (!StringUtil.isBlankOrNull(primaryValue) && !listPrimaryValues.contains(primaryValue)) {
				mapInDoc.put(primaryValue, new InDocument<>(primaryValue, workbookReader));
			}
		}
		createInTables();
		this.docCollection = mapInDoc.values();
	}
	
	private void createInTables() {
		InTable4MultiBatch inTable = null;
		Object detailLinkedValue = null;
		IInDocument<IInTable> inDoc = null;
		for (ExcelTemplateTable templateTable : excelTemplate.getTemplateTables4StampImport()) {
			String sheetName = templateTable.getSheetName();
			int maxRowNum = workbookReader.getLastRowNum(sheetName);
			int startRowNum = templateTable.getStartDtlRowIndex() + ExcelTemplateConstants.ROW_STEP_NEXT;
			IInputReader sheetReader = workbookReader.getSheetReader(sheetName);
			ExcelTemplateField detailLinkedField = templateTable.getDetailLinkedField();
			for (int row = startRowNum; row <= maxRowNum; row++ ) {
				detailLinkedValue = sheetReader.getValue(row, detailLinkedField.getColIndex(), excelProcessContext);
				if (!StringUtil.isBlankOrNull(detailLinkedValue) &&
						mapInDoc.containsKey(detailLinkedValue)) {
					inDoc = mapInDoc.get(detailLinkedValue);
					inTable = (InTable4MultiBatch) inDoc.getTable(templateTable.getTableKey());
					if (inTable == null) {
						inTable = new InTable4MultiBatch(templateTable, workbookReader);
						inDoc.addTable(inTable);
					}
					inTable.addRowNum(row);
				}
			}
		}
	}
	
	@Override
	public Iterator<IInDocument<IInTable>> iterator() {
		return new InDocumentListIterator(this.docCollection);
	}
}
