package com.bokesoft.yes.excel.cmd.stamp.input.reader.picture.struct;

import java.util.HashMap;

import org.apache.poi.ss.usermodel.PictureData;

import com.bokesoft.yes.excel.cmd.stamp.input.reader.picture.item.IPictureDataItem;

/**
 * sheet图片管理类
 * 
 * @author chenbb
 *
 */
public class PictureSheet {
	
	private HashMap<Integer, PictureRow> mapPictureRows = new HashMap<>();
	
	public PictureSheet() {
		this.mapPictureRows = new HashMap<>(); 
	}
	
	public void addPicture(int rowIndex, int colIndex, IPictureDataItem pictureItem) {
		if (pictureItem == null) return;
		PictureRow row = this.ensurePictureRow(rowIndex);
		PictureCell cell = row.ensurePictureCell(colIndex);
		cell.addPictureItem(pictureItem);
	}
	
	public boolean existPicture(int rowIndex, int colIndex) {
		return getPictureCell(rowIndex, colIndex) != null;
	}
	
	public PictureCell getPictureCell(int rowIndex, int colIndex) {
		if (!mapPictureRows.containsKey(rowIndex)) return null;
		return mapPictureRows.get(rowIndex).getPictureCell(colIndex);
	}
	
	private PictureRow ensurePictureRow(int rowIndex) {
		PictureRow row = mapPictureRows.get(rowIndex);
		if (row == null) {
			row = new PictureRow();
			mapPictureRows.put(rowIndex, row);
		}
		return row;
	}
	
	
}
