package com.bokesoft.yes.excel.cmd.stamp.input.reader.picture.struct;

import java.util.ArrayList;
import java.util.StringJoiner;

import com.bokesoft.yes.excel.cmd.stamp.input.reader.picture.item.IPictureDataItem;

/**
 * sheet中的图片所在单元格管理
 * 
 * @author chenbb
 *
 */
public class PictureCell {
	
	private ArrayList<IPictureDataItem> pictureItems = null;
	
	public PictureCell() {
		pictureItems = new ArrayList<>();
	}
	
	public void addPictureItem(IPictureDataItem pictureData) {
		pictureItems.add(pictureData);
	}
	
	public ArrayList<IPictureDataItem> getPictureItems() {
		return this.pictureItems;
	}
	
	public String getPaths() {
		StringJoiner sj = null;
		for (IPictureDataItem item : pictureItems) {
			if (sj == null) {
				sj = new StringJoiner(item.getSperator());
			}
			sj.add(item.getPath());
		}
		return sj == null ? "" : sj.toString();
	}
}
