package com.bokesoft.yes.excel.cmd.stamp.input.reader.picture.builder;

import org.apache.poi.ss.usermodel.PictureData;

import com.bokesoft.yes.excel.cmd.stamp.input.reader.picture.item.IPictureDataItem;
import com.bokesoft.yes.excel.cmd.stamp.input.reader.picture.struct.PictureSheet;

public abstract class AbstractPictureSheetBuilder {
	
	protected PictureSheet pictureSheet = null;
	
	public AbstractPictureSheetBuilder() {
		this.pictureSheet = new PictureSheet();
	}
	
	protected void addPictureItem(int rowIndex, int colIndex, IPictureDataItem pictureItem) {
		this.pictureSheet.addPicture(rowIndex, colIndex, pictureItem);
	}
	
	public abstract PictureSheet build(Object oSheet);

}
