package com.bokesoft.yes.excel.cmd.stamp.input.reader.picture;

import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

import com.bokesoft.yes.excel.cmd.stamp.input.reader.picture.builder.AbstractPictureSheetBuilder;
import com.bokesoft.yes.excel.cmd.stamp.input.reader.picture.builder.HSSFPictureSheetBuilder;
import com.bokesoft.yes.excel.cmd.stamp.input.reader.picture.builder.XSSFPictureSheetBuilder;

public class PictureSheetBuilderFactory {
	public static AbstractPictureSheetBuilder createPictureSheetBuilder(Workbook workbook) {
		if (workbook instanceof HSSFWorkbook) {
			return new HSSFPictureSheetBuilder();
		} else if (workbook instanceof XSSFWorkbook) {
			return new XSSFPictureSheetBuilder();
		} else {
			return new XSSFPictureSheetBuilder();
		}
	}

}
