package com.bokesoft.yes.excel.cmd.stamp.input.doc.in;

import java.util.List;

import com.bokesoft.yes.excel.cmd.stamp.base.ExcelProcessContext;
import com.bokesoft.yes.excel.cmd.stamp.expand.SheetDimensionCreator;
import com.bokesoft.yes.excel.cmd.stamp.input.doc.out.OutTable;
import com.bokesoft.yes.excel.cmd.stamp.input.process.action.IInputRowAction;
import com.bokesoft.yes.excel.cmd.stamp.input.reader.IInputReader;
import com.bokesoft.yes.excel.cmd.stamp.input.reader.IInputReaderBag;
import com.bokesoft.yes.excel.template.ExcelTemplateField;
import com.bokesoft.yes.excel.template.ExcelTemplateTable;
import com.bokesoft.yigo.common.struct.IPairItem;
import com.bokesoft.yigo.struct.expand.processor.DimensionItem;

public class InTable4Expand implements IInTable {
	
	private int startRowIndex, endRowIndex;
	
	private ExcelTemplateTable templateTable = null;
	
	private IInputReaderBag workbookReader = null;
	
	private List<DimensionItem<IPairItem, ExcelTemplateField, ExcelTemplateField>> dimenRoots = null;
	
	public InTable4Expand(ExcelTemplateTable templateTable, int startRowIndex, int endRowIndex, IInputReaderBag workbookReader) {
		this.templateTable = templateTable;
		this.startRowIndex = startRowIndex;
		this.endRowIndex = endRowIndex;
		this.workbookReader = workbookReader;
		IInputReader sheetReader = this.workbookReader.getSheetReader(templateTable.getSheetName());
		SheetDimensionCreator dimensionCreator = new SheetDimensionCreator(templateTable, sheetReader);
		try {
			this.dimenRoots = dimensionCreator.createDimensions(templateTable);
		} catch (Throwable e) {
			e.printStackTrace();
		}
	}

	public ExcelTemplateTable getTemplateTable() {
		return this.templateTable;
	}
	
	@Override
	public String getKey() {
		return templateTable.getTableKey();
	}

	/**
	 * 获取数据结束行， 非明细表数据只存在一行
	 * @return
	 */
	private int getEndRow() {
		return templateTable.isDtlTable() ? this.endRowIndex : this.startRowIndex;
	}

	@Override
	public Object getValue(int row, int col, ExcelProcessContext context) {
		if (row < this.startRowIndex && col == curExpandBaseIndex) {
			//当前为维度字段取值
			return getDimensionValue(row, col);
		}
		
		if (col == curExpandBaseIndex) {
			col = curExpandTargetIndex;
		}
		return workbookReader.getValue(templateTable.getSheetName(), row, col, context);
	}
	
	private String getDimensionValue(int row, int col) {
		DimensionItem<IPairItem, ExcelTemplateField, ExcelTemplateField> tempItem = this.curDimenItem;
		ExcelTemplateField dimensionField = tempItem.getDimensionField();
		while (tempItem != null && dimensionField != null) {
			dimensionField = tempItem.getDimensionField();
			if (dimensionField.getRowIndex() == row && dimensionField.getColIndex() == col) {
				return tempItem.getData().getCaption();
			}
			tempItem = this.curDimenItem.getParent();
		}
		return null;
	}
	
	private int curExpandBaseIndex = 0;
	private int curExpandTargetIndex = 0;
	
	private DimensionItem<IPairItem, ExcelTemplateField, ExcelTemplateField> curDimenItem = null;
	@Override
	public void doInputRowAction(OutTable outTable, IInputRowAction action, ExcelProcessContext context) throws Throwable {
		for (int row = this.getStartRowIndex(); row <= this.getEndRow(); row ++) {
			for (DimensionItem<IPairItem, ExcelTemplateField, ExcelTemplateField> dimenRoot : this.dimenRoots) {
				curExpandBaseIndex = dimenRoot.getSourceField().getColIndex();
				int inc = 0;
				for (DimensionItem<IPairItem, ExcelTemplateField, ExcelTemplateField> dimenItem : dimenRoot.getAllLeafs()) {
					this.curDimenItem = dimenItem;
					curExpandTargetIndex = curExpandBaseIndex + inc;
					action.doAction(row, this, outTable, templateTable, context);
					inc ++;
				}
			}
		}
	}
	
	@Override
	public int getStartRowIndex() {
		return startRowIndex;
	}
	
	@Override
	public boolean isEmptySheetRow(String sheetName, int row) {
		return workbookReader.isEmptySheetRow(sheetName, row);
	}

	@Override
	public boolean isEmptyTableRow(String sheetName, String tableKey, int row) {
		return workbookReader.isEmptyTableRow(sheetName, tableKey, row);
	}
}

