package com.bokesoft.yes.excel.cmd.stamp.base;

import java.util.HashMap;

import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

import com.bokesoft.yes.common.storage.IStorageService;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.excel.cmd.stamp.input.reader.picture.builder.AbstractPictureSheetBuilder;
import com.bokesoft.yes.excel.cmd.stamp.input.reader.picture.storage.DefaultStorageService;
import com.bokesoft.yes.excel.template.ExcelTemplateField;
import com.bokesoft.yes.excel.template.constants.ExcelTemplateConstants;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.document.Document;

public class ExcelProcessContext {
	
	private DefaultContext context = null;
	
	private String formKey = null;
	
	private MetaDataObject metaDataObject = null;
	
	private ScriptEngine engine = null;
	
	private StringBuilder sbCheckResult = null;
	
	private ExcelTemplateField curTemplateField = null;
	
	private AbstractPictureSheetBuilder pictureSheetBuilder = null;
	
	private Document curDocument = null;
	
	public ExcelProcessContext(String formKey, MetaDataObject metaDataObject, DefaultContext context) {
		this.context = context;
		this.formKey = formKey;
		this.metaDataObject = metaDataObject;
		this.sbCheckResult = new StringBuilder("");
		ScriptEngineManager factory = new ScriptEngineManager();
		this.engine = factory.getEngineByName("JavaScript");
	}
	
	public DefaultContext getContext() {
		return this.context;
	}
	
	public String getFormKey() {
		return this.formKey;
	}
	
	public MetaDataObject getMetaDataObject() {
		return this.metaDataObject;
	}
	
	/**
	 * 检查表达式
	 * @param sCheckString
	 * @return
	 */
	public boolean check(String sCheckString) {
		if (StringUtil.isBlankOrNull(sCheckString)) {
			return true;
		}
		if (this.engine != null) {
			try {
				return TypeConvertor.toBoolean(this.engine.eval(sCheckString));
			} catch (ScriptException e) {
				e.printStackTrace();
			}
		}
		return true;
	}

	public void recordError(StringBuilder sbErr) {
		sbCheckResult.append(sbErr).append(ExcelTemplateConstants.S_LINE_BREAK);
	}
	
	public String getError() {
		return this.sbCheckResult.toString();
	}
	
	public boolean hasError() {
		return this.sbCheckResult.length() > 0;
	}
	
	public void setPictureSheetBuilder(AbstractPictureSheetBuilder pictureSheetBuilder) {
		this.pictureSheetBuilder = pictureSheetBuilder;
	}
	
	public AbstractPictureSheetBuilder getPictureSheetBuilder() {
		return this.pictureSheetBuilder;
	}
	
	public void setCurTemplateField(ExcelTemplateField templateField) {
		this.curTemplateField = templateField;
	}
	
	public ExcelTemplateField getCurTemplateField() {
		return this.curTemplateField;
	}
	
	public void setCurDocument(Document document) {
		this.curDocument = document;
	}
	
	public Document getCurDocument() {
		return this.curDocument;
	}
	
	private DefaultStorageService defaultStorageService = new DefaultStorageService();

	private HashMap<String, IStorageService> mapUserDefineStoreServices = new HashMap<>();

	
	public IStorageService getStorage(String className) throws Throwable {
		if (StringUtil.isBlankOrNull(className)) {
			return defaultStorageService;
		}
		if (mapUserDefineStoreServices.containsKey(className)) {
			mapUserDefineStoreServices.get(className);
		} else {
			IStorageService storageService = null;
			try {
				Class<?> c = Class.forName(className);
				storageService = (IStorageService) c.newInstance();
				mapUserDefineStoreServices.put(className, storageService);
				return storageService;
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		throw new Throwable("unknow class name:" + className);
	}
}
