package com.bokesoft.yes.excel.cmd.normal;

import java.io.File;
import java.util.List;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.dts.util.FileUtil;
import com.bokesoft.yes.mid.cmd.DefaultServiceCmd;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yes.struct.filedata.FileData;
import com.bokesoft.yes.tools.util.ReflectHelper;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.excel.IImportService;
import com.bokesoft.yigo.excel.IImportService2;
import com.bokesoft.yigo.meta.enhance.MetaEnhance;
import com.bokesoft.yigo.meta.enhance.MetaExtImportService;
import com.bokesoft.yigo.meta.enhance.MetaImportService;
import com.bokesoft.yigo.mid.base.DefaultContext;

@SuppressWarnings("deprecation")
public class ImportExcelWithFormulaCmd extends DefaultServiceCmd {
	// 表单标识
	private String formKey = null;
	// 文件路径，可能多个文件同时导入
	private FileData fileData = null;
	// 自定义二开到导入服务名
	private String importServiceName = null;
	// 导入后事务，表单保存前执行
	private String postServiceName = null;
	// 是否清除原始数据
	boolean clearOriginalData = false;
	
	@SuppressWarnings("unchecked")
	@Override
	public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
		formKey = TypeConvertor.toString(arguments.get("formKey"));
		List<FileData> list = (List<FileData>)arguments.get("fileDatas");
		fileData = list != null && list.size() > 0 ? list.get(0) : null;
		postServiceName = TypeConvertor.toString(arguments.get("postImportServiceName"));
		importServiceName = TypeConvertor.toString(arguments.get("importServiceName"));
		clearOriginalData = TypeConvertor.toBoolean(arguments.get("clearOriginalData"));
	}

	@Override
	public Object doCmd(DefaultContext context) throws Throwable {
		if(fileData == null){
			return null;
		}
		context.setFormKey(formKey);
		
		Object importService = null;
		// 判断是否调用自定义导入
		if( importServiceName != null && !importServiceName.isEmpty() ) {
			MetaEnhance enhance = context.getVE().getMetaFactory().getEnhance(null);
			if( enhance != null ) {
				MetaImportService service = null;
				MetaExtImportService extService = enhance.getExtImportService();
				if ( extService != null ) {
					service = extService.get(importServiceName);
				}	
				
				if(service != null){
					String impl = service.getImpl();
					importService = ReflectHelper.newInstance(context.getVE(), impl);
				}
			}			
		}
		
		if(importService == null){
			importService = new ImportExcelWithFormulaService();
		}
		

		return importData(context, importService);
	}

	private Object importData(DefaultContext context, Object importService) throws Throwable{
		Object o = null;
		if(importService instanceof IImportService){
			// 生成临时文件
			File tmpFile = FileUtil.createTempFile(fileData, "Import");
			try{
				o = ((IImportService)importService).importData(context, tmpFile, clearOriginalData, postServiceName);
			}finally{
				// 删除临时文件
				try{
					if(tmpFile != null){
						tmpFile.delete();
					}
				}catch(Throwable e){
					e.printStackTrace();
				}
			}
			
		} else {
			((IImportService2)importService).setFormKey(formKey);
			((IImportService2)importService).setClearOriginalData(clearOriginalData);
			((IImportService2)importService).setPostServiceName(postServiceName);
			o = ((IImportService2)importService).importData(context, fileData.getData());
		}
		return o;
	}
	
	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new ImportExcelWithFormulaCmd();
	}

	@Override
	public String getCmd() {
		return null;
	}
	
	public void setFormKey(String formKey) {
		this.formKey = formKey;
	}
	
	public void setImportServiceName(String importServiceName) {
		this.importServiceName = importServiceName;
	}

	public void setPostServiceName(String postImportServiceName) {
		this.postServiceName = postImportServiceName;
	}

	public void setFileData(FileData fileData) {
		this.fileData = fileData;
	}
	
	public void setClearOriginalData(boolean clearOriginalData) {
		this.clearOriginalData = clearOriginalData;
	}
	
	@Override
	public boolean getNeedServiceRight(){
		return true;
	}
}
